"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleCustomizationStatus = void 0;
var _get_initial_usage = require("./get_initial_usage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// we only publish a subset of most important fields that we know can be customized
// this is to avoid telemetry issues if we add new fields to the rule schema
// and to avoid counting fields of lesser importance
// see https://github.com/elastic/kibana/issues/140369 for more information
const ALLOWED_FIELDS = new Set(['alert_suppression', 'anomaly_threshold', 'data_view_id', 'description', 'filters', 'from', 'index', 'interval', 'investigation_fields', 'name', 'new_terms_fields', 'note', 'query', 'risk_score', 'severity', 'setup', 'tags', 'threat_query', 'threshold', 'timeline_id']);
const getRuleCustomizationStatus = ruleSources => {
  const counts = (0, _get_initial_usage.getInitialRuleCustomizationStatus)();
  ruleSources.forEach(ruleSource => {
    if (!ruleSource.is_customized) {
      return;
    }
    ruleSource.customized_fields.forEach(field => {
      const fieldName = field.fieldName;
      if (ALLOWED_FIELDS.has(fieldName)) {
        var _counts$fieldName;
        counts[fieldName] = ((_counts$fieldName = counts[fieldName]) !== null && _counts$fieldName !== void 0 ? _counts$fieldName : 0) + 1;
      }
    });
  });
  return counts;
};
exports.getRuleCustomizationStatus = getRuleCustomizationStatus;