"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleMigrationAgent = getRuleMigrationAgent;
var _langgraph = require("@langchain/langgraph");
var _create_semantic_query = require("./nodes/create_semantic_query");
var _match_prebuilt_rule = require("./nodes/match_prebuilt_rule");
var _state2 = require("./state");
var _translate_rule = require("./sub_graphs/translate_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRuleMigrationAgent({
  model,
  esqlKnowledgeBase,
  ruleMigrationsRetriever,
  logger,
  telemetryClient
}) {
  const matchPrebuiltRuleNode = (0, _match_prebuilt_rule.getMatchPrebuiltRuleNode)({
    model,
    logger,
    ruleMigrationsRetriever,
    telemetryClient
  });
  const translationSubGraph = (0, _translate_rule.getTranslateRuleGraph)({
    model,
    esqlKnowledgeBase,
    ruleMigrationsRetriever,
    telemetryClient,
    logger
  });
  const createSemanticQueryNode = (0, _create_semantic_query.getCreateSemanticQueryNode)({
    model
  });
  const siemMigrationAgentGraph = new _langgraph.StateGraph(_state2.migrateRuleState, _state2.migrateRuleConfigSchema)
  // Nodes
  .addNode('createSemanticQuery', createSemanticQueryNode).addNode('matchPrebuiltRule', matchPrebuiltRuleNode).addNode('translationSubGraph', translationSubGraph)
  // Edges
  .addEdge(_langgraph.START, 'createSemanticQuery').addConditionalEdges('createSemanticQuery', skipPrebuiltRuleConditional, ['matchPrebuiltRule', 'translationSubGraph']).addConditionalEdges('matchPrebuiltRule', matchedPrebuiltRuleConditional, ['translationSubGraph', _langgraph.END]).addEdge('translationSubGraph', _langgraph.END);
  const graph = siemMigrationAgentGraph.compile();
  graph.name = 'Rule Migration Graph'; // Customizes the name displayed in LangSmith
  return graph;
}
const skipPrebuiltRuleConditional = (_state, config) => {
  var _config$configurable;
  if ((_config$configurable = config.configurable) !== null && _config$configurable !== void 0 && _config$configurable.skipPrebuiltRulesMatching) {
    return 'translationSubGraph';
  }
  return 'matchPrebuiltRule';
};
const matchedPrebuiltRuleConditional = state => {
  var _state$elastic_rule;
  if ((_state$elastic_rule = state.elastic_rule) !== null && _state$elastic_rule !== void 0 && _state$elastic_rule.prebuilt_rule_id) {
    return _langgraph.END;
  }
  return 'translationSubGraph';
};