"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringEntitySourceDescriptorClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _monitoring_entity_source_type = require("./monitoring_entity_source_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MonitoringEntitySourceDescriptorClient {
  constructor(dependencies) {
    (0, _defineProperty2.default)(this, "getQueryFilters", query => {
      return Object.entries(query !== null && query !== void 0 ? query : {}).map(([key, value]) => `${_monitoring_entity_source_type.monitoringEntitySourceTypeName}.attributes.${key}: ${value}`).join(' and ');
    });
    this.dependencies = dependencies;
  }
  async create(attributes) {
    var _attributes$managed;
    await this.assertNameUniqueness(attributes);
    const {
      id,
      attributes: created
    } = await this.dependencies.soClient.create(_monitoring_entity_source_type.monitoringEntitySourceTypeName, {
      ...attributes,
      managed: (_attributes$managed = attributes.managed) !== null && _attributes$managed !== void 0 ? _attributes$managed : false
    } // Ensure managed is set to true on creation
    );
    return {
      ...created,
      id
    };
  }
  async update(monitoringEntitySource) {
    await this.assertNameUniqueness(monitoringEntitySource);
    const {
      attributes
    } = await this.dependencies.soClient.update(_monitoring_entity_source_type.monitoringEntitySourceTypeName, monitoringEntitySource.id, monitoringEntitySource, {
      refresh: 'wait_for'
    });
    return attributes;
  }
  async find(query) {
    const scopedSoClient = this.dependencies.soClient.asScopedToNamespace(this.dependencies.namespace);
    return scopedSoClient.find({
      type: _monitoring_entity_source_type.monitoringEntitySourceTypeName,
      filter: this.getQueryFilters(query)
    });
  }
  async get(id) {
    const {
      attributes
    } = await this.dependencies.soClient.get(_monitoring_entity_source_type.monitoringEntitySourceTypeName, id);
    return attributes;
  }
  async delete(id) {
    await this.dependencies.soClient.delete(_monitoring_entity_source_type.monitoringEntitySourceTypeName, id);
  }
  async findByIndex() {
    const result = await this.find();
    return result.saved_objects.filter(so => so.attributes.type === 'index').map(so => ({
      ...so.attributes,
      id: so.id
    }));
  }
  async findAll(query) {
    const result = await this.find(query);
    return result.saved_objects.filter(so => so.attributes.type !== 'csv') // from the spec we are not using CSV on monitoring
    .map(so => ({
      ...so.attributes,
      id: so.id
    }));
  }
  async assertNameUniqueness(attributes) {
    if (attributes.name) {
      const {
        saved_objects: savedObjects
      } = await this.find({
        name: attributes.name
      });

      // Exclude the current entity source if updating
      const filteredSavedObjects = attributes.id ? savedObjects.filter(so => so.id !== attributes.id) : savedObjects;
      if (filteredSavedObjects.length > 0) {
        throw new Error(`A monitoring entity source with the name "${attributes.name}" already exists.`);
      }
    }
  }
}
exports.MonitoringEntitySourceDescriptorClient = MonitoringEntitySourceDescriptorClient;