"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExplorePartialIndexMappingAgent = void 0;
var _langgraph = require("@langchain/langgraph");
var _messages = require("@langchain/core/messages");
var _inspect_index_mapping_tool = require("../../../../tools/inspect_index_mapping_tool/inspect_index_mapping_tool");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExplorePartialIndexMappingAgent = async ({
  createLlmInstance,
  esClient
}) => {
  const llm = await createLlmInstance();
  const tool = (0, _inspect_index_mapping_tool.getInspectIndexMappingTool)({
    esClient,
    indexPattern: 'placeholder'
  });
  const llmWithTools = llm.bindTools([tool]);
  return async state => {
    const {
      messages,
      input
    } = state;
    if (input === undefined) {
      throw new Error('Input is required');
    }
    const result = await llmWithTools.invoke([new _messages.SystemMessage({
      content: 'You are an expert in Elastic Search and particularly at analyzing indices. You have been given a function that allows you' + ' to explore a large index mapping. Use this function to explore the index mapping and determine whether it contains the fields ' + 'required to write the query.'
    }), new _messages.HumanMessage({
      content: `Does the index mapping contain the fields required to generate a query that does the following:\n${input.question}`
    }), ...messages]);
    return new _langgraph.Command({
      update: {
        messages: [result]
      }
    });
  };
};
exports.getExplorePartialIndexMappingAgent = getExplorePartialIndexMappingAgent;