"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueListModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _formatted_date = require("../../common/components/formatted_date");
var _kibana = require("../../common/lib/kibana");
var _add_list_item_popover = require("./add_list_item_popover");
var _upload_list_item = require("./upload_list_item");
var _list_item_table = require("./list_item_table");
var _info = require("./info");
var _translations = require("../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModalBody = (0, _styled.default)(_eui.EuiFlexGroup)`
  overflow: hidden;
  padding: ${({
  theme
}) => theme.euiTheme.size.base};
`;
const modalWindow = (0, _css.css)`
  min-height: 90vh;
  margin-top: 5vh;
  max-width: 1400px;
  min-width: 700px;
`;
const tableStyle = (0, _css.css)`
  overflow: scroll;
`;
const ValueListModal = ({
  listId,
  onCloseModal,
  canWriteIndex
}) => {
  var _listItems$total, _listItems$total2, _list$type, _listItems$data;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [filter, setFilter] = (0, _react.useState)('');
  const http = (0, _kibana.useKibana)().services.http;
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)('updated_at');
  const [sortOrder, setSortOrder] = (0, _react.useState)('desc');
  const {
    data: listItems,
    isLoading: isListItemsLoading,
    isError
  } = (0, _securitysolutionListHooks.useFindListItems)({
    listId,
    pageIndex: pageIndex + 1,
    pageSize,
    sortField,
    sortOrder,
    filter,
    http
  });
  const {
    data: list,
    isLoading: isListLoading
  } = (0, _securitysolutionListHooks.useGetListById)({
    http,
    id: listId
  });
  const onTableChange = ({
    page,
    sort
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
    if (sort) {
      setSortField(sort.field);
      setSortOrder(sort.direction);
    }
  };
  const sorting = {
    sort: {
      field: sortField,
      direction: sortOrder
    },
    enableAllColumns: false
  };
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: (_listItems$total = listItems === null || listItems === void 0 ? void 0 : listItems.total) !== null && _listItems$total !== void 0 ? _listItems$total : 0,
    pageSizeOptions: [5, 10, 25]
  };
  const onQueryChange = (0, _react.useCallback)(params => {
    setFilter(params.queryText);
  }, []);
  const isListExist = !isListLoading && !!list;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    maxWidth: false,
    className: modalWindow,
    onClose: onCloseModal
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, isListExist && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    "data-test-subj": "value-list-items-modal-title"
  }, list.id), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), list.description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, list.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "value-list-items-modal-info",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_info.Info, {
    label: _translations.INFO_TYPE,
    value: list.type
  }), /*#__PURE__*/_react.default.createElement(_info.Info, {
    label: _translations.INFO_UPDATED_AT,
    value: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: list.updated_at,
      fieldName: "updated_at"
    })
  }), /*#__PURE__*/_react.default.createElement(_info.Info, {
    label: _translations.INFO_UPDATED_BY,
    value: list.updated_by
  }), listItems && /*#__PURE__*/_react.default.createElement(_info.Info, {
    label: _translations.INFO_TOTAL_ITEMS,
    value: (_listItems$total2 = listItems === null || listItems === void 0 ? void 0 : listItems.total) !== null && _listItems$total2 !== void 0 ? _listItems$total2 : '-'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, canWriteIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_add_list_item_popover.AddListItemPopover, {
    listId: listId
  }), /*#__PURE__*/_react.default.createElement(_upload_list_item.UploadListItem, {
    listId: listId,
    type: list.type
  }))))), /*#__PURE__*/_react.default.createElement(ModalBody, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    onChange: onQueryChange,
    "data-test-subj": "value-list-items-modal-search-bar",
    box: {
      [`data-test-subj`]: 'value-list-items-modal-search-bar-input',
      placeholder: (0, _translations.getInfoTotalItems)((_list$type = list === null || list === void 0 ? void 0 : list.type) !== null && _list$type !== void 0 ? _list$type : '')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: tableStyle
  }, !isListExist ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xxl"
  }) : /*#__PURE__*/_react.default.createElement(_list_item_table.ListItemTable, {
    items: (_listItems$data = listItems === null || listItems === void 0 ? void 0 : listItems.data) !== null && _listItems$data !== void 0 ? _listItems$data : [],
    pagination: pagination,
    sorting: sorting,
    loading: isListItemsLoading,
    onChange: onTableChange,
    isError: isError,
    canWriteIndex: canWriteIndex,
    list: list
  })))));
};
exports.ValueListModal = ValueListModal;