"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRootCategory = exports.getColumnWidthFromType = exports.getColumnHeaders = exports.getColumnHeader = void 0;
var _fp = require("lodash/fp");
var _constants = require("../constants");
var _default_headers = require("./default_headers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the root category for fields that are only one level, e.g. `_id` or `test_field_1`
 *
 * The `base` category will be returned for fields that are members of `base`,
 * e.g. the `@timestamp`, `_id`, and `message` fields.
 *
 * The field name will be echoed-back for all other fields, e.g. `test_field_1`
 */
const getRootCategory = ({
  browserFields,
  field
}) => (0, _fp.has)(`base.fields.${field}`, browserFields) ? 'base' : field;

/** Enriches the column headers with field details from the specified browserFields */
exports.getRootCategory = getRootCategory;
const getColumnHeaders = (headers, browserFields) => {
  return headers ? headers.map(header => {
    const splitHeader = header.id.split('.'); // source.geo.city_name -> [source, geo, city_name]
    const category = splitHeader.length > 1 ? splitHeader[0] : getRootCategory({
      field: header.id,
      browserFields
    });
    return {
      ...header,
      ...(0, _fp.get)([category, 'fields', header.id], browserFields)
    };
  }) : [];
};
exports.getColumnHeaders = getColumnHeaders;
const getColumnWidthFromType = type => type !== 'date' ? _constants.DEFAULT_COLUMN_MIN_WIDTH : _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH;

/**
 * Returns the column header with field details from the defaultHeaders
 */
exports.getColumnWidthFromType = getColumnWidthFromType;
const getColumnHeader = (fieldName, defaultHeaders) => {
  var _defaultHeaders$find;
  return {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: fieldName,
    initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH,
    ...((_defaultHeaders$find = defaultHeaders.find(c => c.id === fieldName)) !== null && _defaultHeaders$find !== void 0 ? _defaultHeaders$find : {})
  };
};
exports.getColumnHeader = getColumnHeader;