"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconHeaderColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common_styles = require("./common_styles");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/api/timeline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the columns that have icon headers
 */
const getIconHeaderColumns = ({
  timelineType
}) => {
  const columns = {
    note: {
      align: 'center',
      field: 'eventIdToNoteIds',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: i18n.NOTES,
        iconProps: {
          'data-test-subj': 'notes-count-header-icon'
        },
        size: "m",
        type: "editorComment"
      }),
      render: (_, timelineResult) => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "notes-count"
      }, (0, _helpers.getNotesCount)(timelineResult)),
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    },
    pinnedEvent: {
      align: 'center',
      field: 'pinnedEventIds',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: i18n.PINNED_EVENTS,
        iconProps: {
          'data-test-subj': 'pinned-event-header-icon'
        },
        size: "m",
        type: "pin"
      }),
      render: (_, timelineResult) => /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "pinned-event-count"
      }, `${(0, _helpers.getPinnedEventCount)(timelineResult)}`),
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    },
    favorite: {
      align: 'center',
      field: 'favorite',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: i18n.FAVORITES,
        iconProps: {
          'data-test-subj': 'favorites-header-icon'
        },
        size: "m",
        type: "starEmpty"
      }),
      render: favorite => {
        const isFavorite = favorite != null && favorite.length > 0;
        const fill = isFavorite ? 'starFilled' : 'starEmpty';
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          "data-test-subj": `favorite-${fill}-star`,
          type: fill,
          size: "m"
        });
      },
      sortable: false,
      width: _common_styles.ACTION_COLUMN_WIDTH
    }
  };
  const templateColumns = [columns.note, columns.favorite];
  const defaultColumns = [columns.pinnedEvent, columns.note, columns.favorite];
  return timelineType === _timeline.TimelineTypeEnum.template ? templateColumns : defaultColumns;
};
exports.getIconHeaderColumns = getIconHeaderColumns;