"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTIDataView = void 0;
var _react = require("react");
var _containers = require("../../../../sourcerer/containers");
var _indicator = require("../../../../../common/threat_intelligence/types/indicator");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Inline definition for a runtime field "threat.indicator.name" we are adding for indicators grid
 */
const indicatorNameField = {
  aggregatable: true,
  name: _indicator.RawIndicatorFieldId.Name,
  searchable: true,
  type: 'string',
  category: 'threat',
  description: _translations.DESCRIPTION,
  esTypes: ['keyword']
};
const useTIDataView = () => {
  const sourcererDataView = (0, _containers.useSourcererDataView)();
  const browserFields = (0, _react.useMemo)(() => {
    const {
      threat = {
        fields: {}
      }
    } = sourcererDataView.browserFields;
    return {
      ...sourcererDataView.browserFields,
      threat: {
        fields: {
          ...threat.fields,
          [indicatorNameField.name]: indicatorNameField
        }
      }
    };
  }, [sourcererDataView.browserFields]);
  return (0, _react.useMemo)(() => ({
    ...sourcererDataView,
    browserFields,
    patternList: sourcererDataView.selectedPatterns
  }), [browserFields, sourcererDataView]);
};
exports.useTIDataView = useTIDataView;