"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlockListFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_policies = require("../hooks/use_policies");
var _use_block_list_context = require("../../indicators/hooks/use_block_list_context");
var _translations = require("./translations");
var _use_security_context = require("../../../hooks/use_security_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component calling the block list flyout (retrieved from the SecuritySolution plugin via context).
 * This reuses a lot of components passed down via context from the Security Solution plugin:
 * - the flyout component: x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_list_page/components/artifact_flyout.tsx
 * - the form component: x-pack/solutions/security/plugins/security_solution/public/management/pages/blocklist/view/components/blocklist_form.tsx
 */
const BlockListFlyout = ({
  indicatorFileHash
}) => {
  const {
    setBlockListIndicatorValue
  } = (0, _use_block_list_context.useBlockListContext)();
  const {
    blockList
  } = (0, _use_security_context.useSecurityContext)();
  const Component = blockList.getFlyoutComponent();
  const exceptionListApiClient = blockList.exceptionListApiClient;
  const FormComponent = blockList.getFormComponent();
  const {
    isLoading: policiesIsLoading,
    data: policies
  } = (0, _use_policies.usePolicies)();

  // prepopulate the for with the indicator file hash
  const entries = [{
    field: 'file.hash.*',
    operator: 'included',
    type: 'match_any',
    value: [indicatorFileHash]
  }];

  // prepare the payload to pass to the form (and then sent to the blocklist endpoint)
  const item = {
    description: '',
    entries,
    list_id: 'endpoint_blocklists',
    name: '',
    namespace_type: 'agnostic',
    os_types: ['windows'],
    tags: ['policy:all'],
    type: 'simple'
  };

  // texts to customize the flyout
  const labels = {
    flyoutCreateTitle: _translations.ADD_TO_BLOCKLIST_FLYOUT_TITLE
  };
  const clearBlockListIndicatorValue = () => setBlockListIndicatorValue('');
  const props = {
    apiClient: exceptionListApiClient,
    labels,
    item,
    policies: policies || [],
    policiesIsLoading,
    FormComponent,
    onClose: clearBlockListIndicatorValue
  };
  return /*#__PURE__*/_react.default.createElement(Component, props);
};
exports.BlockListFlyout = BlockListFlyout;