"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecurityContext = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _kibana = require("../../common/lib/kibana");
var _user_privileges = require("../../common/components/user_privileges");
var _use_set_url_params = require("../../management/components/artifact_list_page/hooks/use_set_url_params");
var _blocklist_form = require("../../management/pages/blocklist/view/components/blocklist_form");
var _services = require("../../management/pages/blocklist/services");
var _store = require("../../common/store");
var _use_license = require("../../common/hooks/use_license");
var _page_wrapper = require("../../common/components/page_wrapper");
var _use_global_time = require("../../common/containers/use_global_time");
var _actions = require("../../common/store/inputs/actions");
var _constants = require("../../common/store/inputs/constants");
var _artifact_flyout = require("../../management/components/artifact_list_page/components/artifact_flyout");
var _timeline_capabilities = require("../../common/utils/timeline_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSecurityContext = () => {
  const {
    http,
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const dispatch = (0, _reactRedux.useDispatch)();
  const canWriteBlocklist = (0, _user_privileges.useUserPrivileges)().endpointPrivileges.canWriteBlocklist;
  return (0, _react.useMemo)(() => {
    return {
      getPageWrapper: () => _page_wrapper.SecuritySolutionPageWrapper,
      licenseService: _use_license.licenseService,
      hasAccessToTimeline,
      blockList: {
        canWriteBlocklist,
        exceptionListApiClient: _services.BlocklistsApiClient.getInstance(http),
        useSetUrlParams: _use_set_url_params.useSetUrlParams,
        // @ts-ignore
        getFlyoutComponent: () => _artifact_flyout.ArtifactFlyout,
        // @ts-ignore
        getFormComponent: () => _blocklist_form.BlockListForm
      },
      useQuery: () => (0, _reactRedux.useSelector)(_store.inputsSelectors.globalQuerySelector()),
      useFilters: () => (0, _reactRedux.useSelector)(_store.inputsSelectors.globalFiltersQuerySelector()),
      useGlobalTime: _use_global_time.useGlobalTime,
      registerQuery: query => dispatch((0, _actions.setQuery)({
        inputId: _constants.InputsModelId.global,
        id: query.id,
        refetch: query.refetch,
        inspect: null,
        loading: query.loading
      })),
      deregisterQuery: query => dispatch((0, _actions.deleteOneQuery)({
        inputId: _constants.InputsModelId.global,
        id: query.id
      }))
    };
  }, [hasAccessToTimeline, canWriteBlocklist, http, dispatch]);
};
exports.useSecurityContext = useSecurityContext;