"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsReadMore = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _panel_text = require("../../../../common/components/panel_text");
var _use_kibana = require("../../../../common/lib/kibana/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleMigrationsReadMore = exports.RuleMigrationsReadMore = /*#__PURE__*/_react.default.memo(() => {
  const docLink = (0, _use_kibana.useKibana)().services.docLinks.links.securitySolution.siemMigrations;
  return /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "xs",
    subdued: true
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rules.panel.help.readMore",
    defaultMessage: "Read more about our AI powered translations and other features. {readMore}",
    values: {
      readMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.rules.panel.help.readDocs",
        defaultMessage: "Read AI docs"
      }))
    }
  })));
});
RuleMigrationsReadMore.displayName = 'RuleMigrationsReadMore';