"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesDataInputSubSteps = exports.RulesDataInput = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../constants");
var _get_status = require("../common/get_status");
var _sub_step = require("../common/sub_step");
var _copy_export_query = require("./sub_steps/copy_export_query");
var _rules_file_upload = require("./sub_steps/rules_file_upload");
var _check_resources = require("./sub_steps/check_resources");
var _migration_name = require("./sub_steps/migration_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesDataInput = exports.RulesDataInput = /*#__PURE__*/_react.default.memo(({
  dataInputStep,
  migrationStats,
  onMigrationCreated,
  onMissingResourcesFetched
}) => {
  const dataInputStatus = (0, _react.useMemo)(() => (0, _get_status.getStatus)(_constants.DataInputStep.Rules, dataInputStep), [dataInputStep]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepNumber, {
    titleSize: "xs",
    number: _constants.DataInputStep.Rules,
    status: dataInputStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("b", null, i18n.RULES_DATA_INPUT_TITLE))))), dataInputStatus === 'current' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RulesDataInputSubSteps, {
    migrationStats: migrationStats,
    onMigrationCreated: onMigrationCreated,
    onMissingResourcesFetched: onMissingResourcesFetched
  }))));
});
RulesDataInput.displayName = 'RulesDataInput';
const END = 10;
const RulesDataInputSubSteps = exports.RulesDataInputSubSteps = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  onMigrationCreated,
  onMissingResourcesFetched
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services.siemMigrations.rules;
  const [subStep, setSubStep] = (0, _react.useState)(migrationStats ? 4 : 1);
  const [migrationName, setMigrationName] = (0, _react.useState)(migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.name);
  const [isRulesFileReady, setIsRuleFileReady] = (0, _react.useState)(false);

  // Migration name step
  const setName = (0, _react.useCallback)(name => {
    setMigrationName(name);
    if (name) {
      setSubStep(isRulesFileReady ? 3 : 2);
    } else {
      setSubStep(1);
    }
  }, [isRulesFileReady]);
  const nameStep = (0, _migration_name.useMigrationNameStep)({
    status: (0, _get_status.getStatus)(1, subStep),
    setMigrationName: setName,
    migrationName
  });

  // Copy query step
  const onCopied = (0, _react.useCallback)(() => {
    setSubStep(currentSubStep => currentSubStep !== 1 ? 3 : currentSubStep); // Move to the next step only if step 1 was completed
    telemetry.reportSetupRulesQueryCopied({
      migrationId: migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id
    });
  }, [telemetry, migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id]);
  const copyStep = (0, _copy_export_query.useCopyExportQueryStep)({
    status: (0, _get_status.getStatus)(2, subStep),
    onCopied
  });

  // Upload rules step
  const onMigrationCreatedStep = (0, _react.useCallback)(stats => {
    onMigrationCreated(stats);
    setSubStep(4);
  }, [onMigrationCreated]);
  const onRulesFileChanged = (0, _react.useCallback)(files => {
    setIsRuleFileReady(!!(files !== null && files !== void 0 && files.length));
    setSubStep(3);
  }, []);
  const uploadStep = (0, _rules_file_upload.useRulesFileUploadStep)({
    status: (0, _get_status.getStatus)(3, subStep),
    migrationStats,
    onRulesFileChanged,
    onMigrationCreated: onMigrationCreatedStep,
    migrationName
  });

  // Check missing resources step
  const onMissingResourcesFetchedStep = (0, _react.useCallback)(missingResources => {
    onMissingResourcesFetched(missingResources);
    setSubStep(END);
  }, [onMissingResourcesFetched]);
  const resourcesStep = (0, _check_resources.useCheckResourcesStep)({
    status: (0, _get_status.getStatus)(4, subStep),
    migrationStats,
    onMissingResourcesFetched: onMissingResourcesFetchedStep
  });
  const steps = (0, _react.useMemo)(() => [nameStep, copyStep, uploadStep, resourcesStep], [nameStep, copyStep, uploadStep, resourcesStep]);
  return /*#__PURE__*/_react.default.createElement(_sub_step.SubSteps, {
    steps: steps
  });
});
RulesDataInputSubSteps.displayName = 'RulesDataInputActive';