"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MacrosDataInputSubSteps = exports.MacrosDataInput = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana_react = require("../../../../../../common/lib/kibana/kibana_react");
var _get_status = require("../common/get_status");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../constants");
var _sub_step = require("../common/sub_step");
var _copy_export_query = require("./sub_steps/copy_export_query");
var _macros_file_upload = require("./sub_steps/macros_file_upload");
var _check_resources = require("./sub_steps/check_resources");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MacrosDataInput = exports.MacrosDataInput = /*#__PURE__*/_react.default.memo(({
  dataInputStep,
  migrationStats,
  missingMacros,
  onMissingResourcesFetched
}) => {
  const dataInputStatus = (0, _react.useMemo)(() => (0, _get_status.getStatus)(_constants.DataInputStep.Macros, dataInputStep), [dataInputStep]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepNumber, {
    titleSize: "xs",
    number: _constants.DataInputStep.Macros,
    status: dataInputStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("b", null, i18n.MACROS_DATA_INPUT_TITLE))))), dataInputStatus === 'current' && migrationStats && missingMacros && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(MacrosDataInputSubSteps, {
    migrationStats: migrationStats,
    missingMacros: missingMacros,
    onMissingResourcesFetched: onMissingResourcesFetched
  }))));
});
MacrosDataInput.displayName = 'MacrosDataInput';
const END = 10;
const MacrosDataInputSubSteps = exports.MacrosDataInputSubSteps = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  missingMacros,
  onMissingResourcesFetched
}) => {
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services.siemMigrations.rules;
  const [subStep, setSubStep] = (0, _react.useState)(missingMacros.length ? 1 : 3);

  // Copy query step
  const onCopied = (0, _react.useCallback)(() => {
    setSubStep(2);
    telemetry.reportSetupMacrosQueryCopied({
      migrationId: migrationStats.id
    });
  }, [telemetry, migrationStats.id]);
  const copyStep = (0, _copy_export_query.useCopyExportQueryStep)({
    status: (0, _get_status.getStatus)(1, subStep),
    onCopied
  });

  // Upload macros step
  const onMacrosCreatedStep = (0, _react.useCallback)(() => {
    setSubStep(3);
  }, []);
  const uploadStep = (0, _macros_file_upload.useMacrosFileUploadStep)({
    status: (0, _get_status.getStatus)(2, subStep),
    migrationStats,
    missingMacros,
    onMacrosCreated: onMacrosCreatedStep
  });

  // Check missing resources step
  const onMissingResourcesFetchedStep = (0, _react.useCallback)(newMissingResources => {
    onMissingResourcesFetched(newMissingResources);
    setSubStep(END);
  }, [onMissingResourcesFetched]);
  const resourcesStep = (0, _check_resources.useCheckResourcesStep)({
    status: (0, _get_status.getStatus)(3, subStep),
    migrationStats,
    onMissingResourcesFetched: onMissingResourcesFetchedStep
  });
  const steps = (0, _react.useMemo)(() => [copyStep, uploadStep, resourcesStep], [copyStep, uploadStep, resourcesStep]);
  return /*#__PURE__*/_react.default.createElement(_sub_step.SubSteps, {
    steps: steps
  });
});
MacrosDataInputSubSteps.displayName = 'MacrosDataInputActive';