"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationDataInputWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("./context");
var _data_input_flyout = require("./data_input_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleMigrationDataInputWrapper = exports.RuleMigrationDataInputWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  onFlyoutClosed
}) => {
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)();
  const [flyoutMigrationStats, setFlyoutMigrationStats] = (0, _react.useState)();
  const closeFlyout = (0, _react.useCallback)(() => {
    setIsFlyoutOpen(false);
    setFlyoutMigrationStats(undefined);
    onFlyoutClosed === null || onFlyoutClosed === void 0 ? void 0 : onFlyoutClosed();
  }, [onFlyoutClosed]);
  const openFlyout = (0, _react.useCallback)(migrationStats => {
    setFlyoutMigrationStats(migrationStats);
    setIsFlyoutOpen(true);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_context.RuleMigrationDataInputContextProvider, {
    openFlyout: openFlyout,
    closeFlyout: closeFlyout
  }, children, isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_data_input_flyout.MigrationDataInputFlyout, {
    onClose: closeFlyout,
    migrationStats: flyoutMigrationStats
  }));
});
RuleMigrationDataInputWrapper.displayName = 'RuleMigrationDataInputWrapper';