"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnboardingHeaderStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOnboardingHeaderStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _css.css)`
    .onboardingHeaderTitleWrapper {
      width: calc(${_constants.PAGE_CONTENT_WIDTH} / 2);
    }
    .onboardingHeaderGreetings {
      color: ${euiTheme.colors.textSubdued};
    }
    .onboardingHeaderTopicSelector {
      width: calc(${_constants.PAGE_CONTENT_WIDTH} / 3);
    }
  `;
};
exports.useOnboardingHeaderStyles = useOnboardingHeaderStyles;