"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDarkPanelStyles = exports.useCardPanelStyles = exports.HEIGHT_ANIMATION_DURATION = void 0;
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HEIGHT_ANIMATION_DURATION = exports.HEIGHT_ANIMATION_DURATION = 250;
const useCardPanelStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const successBackgroundColor = euiTheme.colors.backgroundBaseSuccess;
  const darkModeStyles = useDarkPanelStyles(isDarkMode);
  return (0, _css.css)`
    .onboardingCardHeader {
      padding: calc(${euiTheme.size.s} * 2);
      cursor: pointer;
    }
    .onboardingCardIcon {
      padding: ${euiTheme.size.m};
      border-radius: 50%;
      background-color: ${isDarkMode ? euiTheme.colors.lightShade : euiTheme.colors.backgroundBaseSubdued};
      display: flex;
      align-items: center;
    }
    .onboardingCardHeaderTitle {
      font-weight: ${euiTheme.font.weight.semiBold};
    }
    .onboardingCardHeaderCompleteBadge {
      background-color: ${isDarkMode ? euiTheme.colors.success : successBackgroundColor};
      color: ${isDarkMode ? euiTheme.colors.emptyShade : euiTheme.colors.textSuccess};
    }
    .onboardingCardContentWrapper {
      display: grid;
      visibility: collapse;
      grid-template-rows: 0fr;
      transition: grid-template-rows ${HEIGHT_ANIMATION_DURATION}ms ease-in,
        visibility ${euiTheme.animation.normal} ${euiTheme.animation.resistance};
    }
    .onboardingCardContent {
      overflow: hidden;
    }

    &.onboardingCardPanel-expanded {
      border: 2px solid ${euiTheme.colors.primary};

      .onboardingCardContentWrapper {
        visibility: visible;
        grid-template-rows: 1fr;
      }
    }

    &.onboardingCardPanel-completed {
      .onboardingCardIcon {
        background-color: ${successBackgroundColor};
      }
    }
    ${darkModeStyles}
  `;
};
exports.useCardPanelStyles = useCardPanelStyles;
const useDarkPanelStyles = isDarkMode => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const darkPanelStyles = (0, _css.css)`
    background-color: ${euiTheme.colors.backgroundBasePlain};
    border-color: ${euiTheme.colors.borderBasePlain};
  `;
  return isDarkMode ? darkPanelStyles : '';
};
exports.useDarkPanelStyles = useDarkPanelStyles;