"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActiveIntegrationsCalloutComponent = exports.ActiveIntegrationsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _agent_required_callout = require("./agent_required_callout");
var _manage_integrations_callout = require("./manage_integrations_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActiveIntegrationsCalloutComponent = ({
  activeIntegrationsCount,
  isAgentRequired
}) => {
  return isAgentRequired ? /*#__PURE__*/_react.default.createElement(_agent_required_callout.AgentRequiredCallout, null) : /*#__PURE__*/_react.default.createElement(_manage_integrations_callout.ManageIntegrationsCallout, {
    activeIntegrationsCount: activeIntegrationsCount
  });
};
exports.ActiveIntegrationsCalloutComponent = ActiveIntegrationsCalloutComponent;
const ActiveIntegrationsCallout = exports.ActiveIntegrationsCallout = /*#__PURE__*/_react.default.memo(ActiveIntegrationsCalloutComponent);
ActiveIntegrationsCallout.displayName = 'ActiveIntegrationsCallout';