"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOW_INSIGHTS = exports.OVERVIEW = exports.ACTIVITY_LOG = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OVERVIEW = exports.OVERVIEW = _i18n.i18n.translate('xpack.securitySolution.endpointDetails.overview', {
  defaultMessage: 'Overview'
});
const WORKFLOW_INSIGHTS = exports.WORKFLOW_INSIGHTS = {
  title: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.sectionTitle', {
    defaultMessage: 'Automatic Troubleshooting'
  }),
  titleRight: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.extraAction', {
    defaultMessage: 'Last scans:'
  }),
  scan: {
    title: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.scan.title', {
      defaultMessage: 'Automatic Troubleshooting'
    }),
    button: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.scan.button', {
      defaultMessage: 'Scan'
    }),
    loading: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.scan.loading', {
      defaultMessage: 'Loading...'
    }),
    noPermissions: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.scan.noPermissions', {
      defaultMessage: 'You do not have the privileges required to perform this operation.'
    })
  },
  issues: {
    title: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.issues.title', {
      defaultMessage: 'Insights'
    }),
    survey: {
      description: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.survey.text', {
        defaultMessage: 'How is Automatic Troubleshooting working for you? '
      }),
      callToAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.survey.callToAction', {
        defaultMessage: 'Provide feedback'
      })
    },
    emptyResults: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.issues.emptyResults', {
      defaultMessage: 'Troubleshooting scan complete, no issues found.'
    }),
    remediationButton: {
      ariaLabel: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.issues.insightRemediationButtonAriaLabel', {
        defaultMessage: 'Create trusted app'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.issues.insightRemediationButtonTooltipContent', {
        defaultMessage: 'Create trusted app'
      }),
      tooltipNoPermissions: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.issues.insightRemediationButtonTooltipNoPermissions', {
        defaultMessage: 'You do not have the privileges required to perform this operation.'
      })
    }
  },
  toasts: {
    scanError: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.toast.error', {
      defaultMessage: 'Failed to start scan'
    }),
    fetchInsightsError: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.toast.fetchInsightsError', {
      defaultMessage: 'Failed to fetch insights'
    }),
    fetchPendingInsightsError: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.toast.fetchPendingInsightsError', {
      defaultMessage: 'Failed to retrieve insights in the generation process'
    }),
    updateInsightError: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.toast.updateInsightError', {
      defaultMessage: 'Failed to mark insight as remediated'
    }),
    maxFetchAttemptsReached: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.workflowInsights.toast.maxFetchAttemptsReached', {
      defaultMessage: 'Failed to fetch insights after multiple attempts'
    })
  }
};
const ACTIVITY_LOG = exports.ACTIVITY_LOG = {
  tabTitle: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.responseActionsHistory', {
    defaultMessage: 'Response actions history'
  }),
  LogEntry: {
    endOfLog: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.endOfLog', {
      defaultMessage: 'Nothing more to show'
    }),
    dateRangeMessage: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.dateRangeMessage.title', {
      defaultMessage: 'Nothing to show for selected date range, please select another and try again.'
    }),
    emptyState: {
      title: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.emptyState.title', {
        defaultMessage: 'No logged actions'
      }),
      body: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.emptyState.body', {
        defaultMessage: 'No actions have been logged for this endpoint.'
      })
    },
    action: {
      isolatedAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.isolated', {
        defaultMessage: 'submitted request: Isolate host'
      }),
      unisolatedAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.unisolated', {
        defaultMessage: 'submitted request: Release host'
      }),
      failedEndpointReleaseAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.failedEndpointReleaseAction', {
        defaultMessage: 'failed to submit request: Release host'
      }),
      failedEndpointIsolateAction: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.action.failedEndpointIsolateAction', {
        defaultMessage: 'failed to submit request: Isolate host'
      })
    },
    response: {
      isolationCompletedAndSuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.isolationCompletedAndSuccessful', {
        defaultMessage: 'Host isolation request completed by Endpoint'
      }),
      isolationCompletedAndUnsuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.isolationCompletedAndUnsuccessful', {
        defaultMessage: 'Host isolation request completed by Endpoint with errors'
      }),
      unisolationCompletedAndSuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.unisolationCompletedAndSuccessful', {
        defaultMessage: 'Release request completed by Endpoint'
      }),
      unisolationCompletedAndUnsuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.unisolationCompletedAndUnsuccessful', {
        defaultMessage: 'Release request completed by Endpoint with errors'
      }),
      isolationSuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.isolationSuccessful', {
        defaultMessage: 'Host isolation request received by Endpoint'
      }),
      isolationFailed: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.isolationFailed', {
        defaultMessage: 'Host isolation request received by Endpoint with errors'
      }),
      unisolationSuccessful: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.unisolationSuccessful', {
        defaultMessage: 'Release host request received by Endpoint'
      }),
      unisolationFailed: _i18n.i18n.translate('xpack.securitySolution.endpointDetails.activityLog.logEntry.response.unisolationFailed', {
        defaultMessage: 'Release host request received by Endpoint with errors'
      })
    }
  }
};