"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenuItemNavByRouter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_navigate_to_app_event_handler = require("../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiContextMenuItem = (0, _styledComponents.default)(_eui.EuiContextMenuItem)`
  .additional-info {
    display: none;
    max-width: 50%;
  }
  &:hover {
    .additional-info {
      display: block !important;
    }
  }
`;
const StyledEuiFlexItem = (0, _styledComponents.default)('div')`
  max-width: 50%;
  padding-right: ${props => props.theme.eui.euiSizeS};
`;

/**
 * Just like `EuiContextMenuItem`, but allows for additional props to be defined which will
 * allow navigation to a URL path via React Router
 */
const ContextMenuItemNavByRouter = exports.ContextMenuItemNavByRouter = /*#__PURE__*/(0, _react.memo)(({
  navigateAppId,
  navigateOptions,
  onClick,
  textTruncate,
  hoverInfo,
  children,
  href,
  isNavigationDisabled = false,
  ...otherMenuItemProps
}) => {
  const handleOnClickViaNavigateToApp = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(navigateAppId !== null && navigateAppId !== void 0 ? navigateAppId : '', {
    ...navigateOptions,
    onClick
  });
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(otherMenuItemProps['data-test-subj']);
  const hoverComponentInstance = (0, _react.useMemo)(() => {
    // If the `hoverInfo` is not an object (ex. text, number), then auto-add the text truncation className.
    // Adding this when the `hoverInfo` is a react component could cause issue, thus in those cases, we
    // assume the component will handle how the data is truncated (if applicable)
    const cssClassNames = `additional-info ${'object' !== typeof hoverInfo ? 'eui-textTruncate' : ''}`;
    return hoverInfo ? /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
      className: cssClassNames
    }, hoverInfo) : null;
  }, [hoverInfo]);
  const handleItemClick = (0, _react.useCallback)(ev => {
    if (isNavigationDisabled) {
      return;
    }
    if (navigateAppId) {
      handleOnClickViaNavigateToApp(ev);
    } else if (onClick) {
      onClick(ev);
    }
  }, [handleOnClickViaNavigateToApp, isNavigationDisabled, navigateAppId, onClick]);
  const content = textTruncate ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: "eui-textTruncate",
    "data-test-subj": getTestId('truncateWrapper')
  }, 'string' === typeof children ? {
    title: children
  } : {}), children), hoverComponentInstance) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), hoverComponentInstance);
  return /*#__PURE__*/_react.default.createElement(StyledEuiContextMenuItem, (0, _extends2.default)({}, otherMenuItemProps, {
    onClick: handleItemClick,
    href: isNavigationDisabled ? undefined : href
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, content));
});
ContextMenuItemNavByRouter.displayName = 'EuiContextMenuItemNavByRouter';