"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactConfirmModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ArtifactConfirmModal = exports.ArtifactConfirmModal = /*#__PURE__*/(0, _react.memo)(({
  title,
  body,
  confirmButton,
  cancelButton,
  onCancel,
  onSuccess,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const artifactConfirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCancel,
    "data-test-subj": dataTestSubj,
    "aria-labelledby": artifactConfirmModalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    "data-test-subj": getTestId('header')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: artifactConfirmModalTitleId
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    "data-test-subj": getTestId('body')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, body))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": getTestId('cancelButton')
  }, cancelButton), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onSuccess,
    "data-test-subj": getTestId('submitButton')
  }, confirmButton)));
});
ArtifactConfirmModal.displayName = 'ArtifactConfirmModal';