"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringErrorStep = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedUserMonitoringErrorStep = ({
  result,
  validLinesAsText,
  errorMessage,
  goToFirstStep,
  onClose
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (errorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "cross",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.errorTitle",
        defaultMessage: "Error uploading file"
      })
    }, /*#__PURE__*/_react.default.createElement("p", null, errorMessage)), /*#__PURE__*/_react.default.createElement(ErrorStepFooter, {
      onTryAgain: goToFirstStep,
      onClose: onClose
    }));
  }
  if (result === undefined || result.stats.failed === 0) {
    return null;
  }
  const annotations = (0, _helpers.buildAnnotationsFromError)(result.errors);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Some privileged user assignments were unsuccessful due to errors.",
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.title"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{assignedCount, plural, one {# privileged user assignment succeeded.} other {# privileged user assignments succeeded.}}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.assignedEntities",
    values: {
      assignedCount: result.stats.successful
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: euiTheme.colors.danger
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{failedCount, plural, one {# privileged user assignment failed.} other {# privileged user assignments failed.}}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.failedEntities",
    values: {
      failedCount: result.stats.failed
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 300,
    language: "CSV",
    isVirtualized: true,
    css: (0, _react2.css)`
            border: 1px solid ${euiTheme.colors.warning};
          `,
    lineNumbers: {
      annotations
    }
  }, validLinesAsText)), /*#__PURE__*/_react.default.createElement(ErrorStepFooter, {
    onTryAgain: goToFirstStep,
    onClose: onClose
  }));
};
exports.PrivilegedUserMonitoringErrorStep = PrivilegedUserMonitoringErrorStep;
const ErrorStepFooter = ({
  onTryAgain,
  onClose
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: onClose
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.cancelButton",
  defaultMessage: "Cancel"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  onClick: onTryAgain,
  color: "primary",
  fill: true
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.tryAgainButton",
  defaultMessage: "Try again"
})))));