"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleRiskEngineCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_schedule_now_risk_engine_mutation = require("../../../api/hooks/use_schedule_now_risk_engine_mutation");
var _use_risk_engine_status = require("../../../api/hooks/use_risk_engine_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TEN_SECONDS = 10000;
const ScheduleRiskEngineCallout = () => {
  var _riskEngineStatus$ris;
  const {
    data: riskEngineStatus,
    isLoading: isRiskEngineStatusLoading
  } = (0, _use_risk_engine_status.useRiskEngineStatus)({
    refetchInterval: TEN_SECONDS,
    structuralSharing: false // Force the component to rerender after every Risk Engine Status API call
  });
  const isRunning = (riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : (_riskEngineStatus$ris = riskEngineStatus.risk_engine_task_status) === null || _riskEngineStatus$ris === void 0 ? void 0 : _riskEngineStatus$ris.status) === 'running';
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    isLoading: isLoadingRiskEngineSchedule,
    mutate: scheduleRiskEngineMutation
  } = (0, _use_schedule_now_risk_engine_mutation.useScheduleNowRiskEngineMutation)({
    onSuccess: () => addSuccess(_i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.riskEngine.successMessage', {
      defaultMessage: 'Risk engine run scheduled'
    })),
    onError: error => addError(error, {
      title: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.riskEngine.errorMessage', {
        defaultMessage: 'Risk engine schedule failed'
      })
    })
  });
  const countDownText = (0, _use_risk_engine_status.useRiskEngineCountdownTime)(riskEngineStatus);
  const scheduleRiskEngine = (0, _react.useCallback)(() => {
    scheduleRiskEngineMutation();
  }, [scheduleRiskEngineMutation]);
  if ((riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status) !== _entity_analytics.RiskEngineStatusEnum.ENABLED) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "risk-engine-callout",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Entity risk score",
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.riskEngine.calloutTitle"
    }),
    color: "primary",
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The assigned criticality levels will impact entity risk scores on the next engine run.",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.riskEngine.calloutText"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The next scheduled engine run is in:",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.riskEngine.scheduleText"
  }), /*#__PURE__*/_react.default.createElement("b", null, ` ${countDownText}`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "play",
    size: "xs",
    onClick: scheduleRiskEngine,
    isLoading: isLoadingRiskEngineSchedule || isRiskEngineStatusLoading || isRunning
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Recalculate entity risk scores now",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.riskEngine.runNowButton"
  })))));
};
exports.ScheduleRiskEngineCallout = ScheduleRiskEngineCallout;