"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsLink = exports.alertSummaryLink = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsLink = exports.alertsLink = {
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.SECURITY_FEATURE_ID}.detections`]],
  globalNavPosition: 3,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.alerts', {
    defaultMessage: 'Alerts'
  })],
  id: _constants.SecurityPageName.alerts,
  path: _constants.ALERTS_PATH,
  title: _translations.ALERTS
};
const alertSummaryLink = exports.alertSummaryLink = {
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.SECURITY_FEATURE_ID}.external_detections`]],
  globalNavPosition: 3,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.alertSummary', {
    defaultMessage: 'Alert summary'
  })],
  hideTimeline: true,
  id: _constants.SecurityPageName.alertSummary,
  path: _constants.ALERT_SUMMARY_PATH,
  title: _translations.ALERT_SUMMARY
};