"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingPage = exports.LANDING_PAGE_VIEW_ALL_INTEGRATIONS_BUTTON_TEST_ID = exports.LANDING_PAGE_PROMPT_TEST_ID = exports.LANDING_PAGE_IMAGE_TEST_ID = exports.LANDING_PAGE_CARD_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _integration_card = require("./integration_card");
var _alert_summary = _interopRequireDefault(require("./alert_summary.png"));
var _use_navigate_to_integrations_page = require("../../../hooks/alert_summary/use_navigate_to_integrations_page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.landingPage.title', {
  defaultMessage: 'All your alerts in one place with AI'
});
const SUB_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.landingPage.subTitle', {
  defaultMessage: 'Bring in your SIEM data to begin surfacing alerts'
});
const DATA_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.landingPage.dataTitle', {
  defaultMessage: 'Start by connecting your data'
});
const VIEW_ALL_INTEGRATIONS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.landingPage.viewAllIntegrationsButtonLabel', {
  defaultMessage: 'View all integrations'
});
const PRIMARY_INTEGRATIONS = ['splunk', 'google_secops'];
const LANDING_PAGE_PROMPT_TEST_ID = exports.LANDING_PAGE_PROMPT_TEST_ID = 'alert-summary-landing-page-prompt';
const LANDING_PAGE_IMAGE_TEST_ID = exports.LANDING_PAGE_IMAGE_TEST_ID = 'alert-summary-landing-page-image';
const LANDING_PAGE_CARD_TEST_ID = exports.LANDING_PAGE_CARD_TEST_ID = 'alert-summary-landing-page-card-';
const LANDING_PAGE_VIEW_ALL_INTEGRATIONS_BUTTON_TEST_ID = exports.LANDING_PAGE_VIEW_ALL_INTEGRATIONS_BUTTON_TEST_ID = 'alert-summary-landing-page-view-all-integrations-button';
/**
 * Displays a gif of the alerts summary page, with empty prompt showing the top 2 available AI for SOC packages.
 * This page is rendered when no AI for SOC packages are installed.
 */
const LandingPage = exports.LandingPage = /*#__PURE__*/(0, _react.memo)(({
  packages
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const navigateToIntegrationsPage = (0, _use_navigate_to_integrations_page.useNavigateToIntegrationsPage)();

  // We only want to show the 2 top integrations, Splunk and GoogleSecOps, in that specific order
  const primaryPackages = (0, _react.useMemo)(() => packages.filter(pkg => PRIMARY_INTEGRATIONS.includes(pkg.name)).sort((a, b) => PRIMARY_INTEGRATIONS.indexOf(a.name) - PRIMARY_INTEGRATIONS.indexOf(b.name)), [packages]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": LANDING_PAGE_PROMPT_TEST_ID,
    direction: "column",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
          // to have the background color correctly applied
          // we need to compensate for the 24px padding that is applied to a parent component
          //(see here x-pack/solutions/security/plugins/security_solution/public/app/home/template_wrapper/index.tsx)
          margin: -${euiTheme.size.l} -${euiTheme.size.l} 0 -${euiTheme.size.l};
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column",
    css: (0, _react2.css)`
            background-color: ${euiTheme.colors.backgroundBaseSubdued};
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, SUB_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage // TODO replace the image with a proper gif or video once provided by UIUX
  , {
    "data-test-subj": LANDING_PAGE_IMAGE_TEST_ID,
    size: "original",
    role: "presentation",
    alt: "",
    src: _alert_summary.default
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, DATA_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, primaryPackages.map(pkg => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: pkg.name
  }, /*#__PURE__*/_react.default.createElement(_integration_card.IntegrationCard, {
    integration: pkg,
    "data-test-subj": `${LANDING_PAGE_CARD_TEST_ID}${pkg.name}`
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": LANDING_PAGE_VIEW_ALL_INTEGRATIONS_BUTTON_TEST_ID,
    iconType: "plusInCircle",
    onClick: navigateToIntegrationsPage
  }, VIEW_ALL_INTEGRATIONS)))));
});
LandingPage.displayName = 'LandingPage';