"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryReadOnly = EqlQueryReadOnly;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var descriptionStepI18n = _interopRequireWildcard(require("../../../../../../../rule_creation_ui/components/description_step/translations"));
var _rule_definition_section = require("../../../../rule_definition_section");
var _helpers = require("../../../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EqlQueryReadOnly({
  eqlQuery,
  dataSource
}) {
  const listItems = [{
    title: descriptionStepI18n.EQL_QUERY_LABEL,
    description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.Query, {
      query: eqlQuery.query
    })
  }];
  if ((0, _helpers.isFilters)(eqlQuery.filters) && eqlQuery.filters.length > 0) {
    const dataSourceProps = (0, _helpers.getDataSourceProps)(dataSource);
    listItems.push({
      title: descriptionStepI18n.FILTERS_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.Filters, (0, _extends2.default)({
        filters: eqlQuery.filters
      }, dataSourceProps))
    });
  }
  if (eqlQuery.event_category_override) {
    listItems.push({
      title: descriptionStepI18n.EQL_EVENT_CATEGORY_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, eqlQuery.event_category_override)
    });
  }
  if (eqlQuery.tiebreaker_field) {
    listItems.push({
      title: descriptionStepI18n.EQL_TIEBREAKER_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, eqlQuery.tiebreaker_field)
    });
  }
  if (eqlQuery.timestamp_field) {
    listItems.push({
      title: descriptionStepI18n.EQL_TIMESTAMP_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, eqlQuery.timestamp_field)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems
  });
}