"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AndBadgeComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _and_or_badge = require("../and_or_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyInvisibleAndBadge = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  visibility: hidden;
`;
const MyFirstRowContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-top: 20px;
`;
const AndBadgeComponent = exports.AndBadgeComponent = /*#__PURE__*/_react.default.memo(({
  entriesLength,
  entryItemIndex
}) => {
  const badge = /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    includeAntennas: true,
    type: "and"
  });
  if (entriesLength > 1 && entryItemIndex === 0) {
    return /*#__PURE__*/_react.default.createElement(MyFirstRowContainer, {
      grow: false,
      "data-test-subj": "entryItemEntryFirstRowAndBadge"
    }, badge);
  } else if (entriesLength <= 1) {
    return /*#__PURE__*/_react.default.createElement(MyInvisibleAndBadge, {
      grow: false,
      "data-test-subj": "entryItemEntryInvisibleAndBadge"
    }, badge);
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "entryItemEntryAndBadge"
    }, badge);
  }
});
AndBadgeComponent.displayName = 'AndBadge';