"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SplitAccordion = ({
  header,
  initialIsOpen,
  'data-test-subj': dataTestSubj,
  children
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    "data-test-subj": `${dataTestSubj}Wrapper`,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    initialIsOpen: initialIsOpen,
    className: (0, _css.css)`
          .euiAccordion__triggerWrapper {
            background: ${euiTheme.colors.backgroundBaseSubdued};
            padding: ${euiTheme.size.m};
          }
        `,
    buttonContent: header
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    "data-test-subj": `${dataTestSubj}Content`,
    color: "transparent"
  }, children)));
};
exports.SplitAccordion = SplitAccordion;