"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATED_ALERTS_WITH_VERSION_CONFLICTS = exports.SUCCESSFULLY_MARKED_ALERTS = exports.PARTIALLY_UPDATED_ALERTS = exports.ERROR_UPDATING_ALERTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_UPDATING_ALERTS = exports.ERROR_UPDATING_ALERTS = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.useUpdateAlerts.errorUpdatingAlertsTitle', {
  defaultMessage: 'Unable to update alerts'
});
const PARTIALLY_UPDATED_ALERTS = ({
  alertsCount,
  kibanaAlertWorkflowStatus,
  updated
}) => {
  return _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.useUpdateAlerts.partiallyUpdatedAlertsMessage', {
    defaultMessage: 'Marked {updated} out of {alertsCount} alerts as {kibanaAlertWorkflowStatus}. {notUpdated, plural, =1 {1 alert could not be updated.} other {{notUpdated} alerts could not be updated.}}',
    values: {
      alertsCount,
      kibanaAlertWorkflowStatus,
      notUpdated: alertsCount - updated,
      updated
    }
  });
};
exports.PARTIALLY_UPDATED_ALERTS = PARTIALLY_UPDATED_ALERTS;
const SUCCESSFULLY_MARKED_ALERTS = ({
  kibanaAlertWorkflowStatus,
  updated
}) => {
  return _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.useUpdateAlerts.successfullyMarkedAlertsMessage', {
    defaultMessage: 'Marked {updated, plural, =1 {1 alert} other {{updated} alerts}} as {kibanaAlertWorkflowStatus}',
    values: {
      updated,
      kibanaAlertWorkflowStatus
    }
  });
};
exports.SUCCESSFULLY_MARKED_ALERTS = SUCCESSFULLY_MARKED_ALERTS;
const UPDATED_ALERTS_WITH_VERSION_CONFLICTS = ({
  kibanaAlertWorkflowStatus,
  updated,
  versionConflicts
}) => {
  return _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.useUpdateAlerts.updatedAlertsWithVersionConflictsMessage', {
    defaultMessage: '{updated, plural, =0 {No alerts were marked as {kibanaAlertWorkflowStatus}} =1 {Marked 1 alert as {kibanaAlertWorkflowStatus}} other {Marked {updated} alerts as {kibanaAlertWorkflowStatus}}} {versionConflicts, plural, =1 {1 alert could not be updated due to a version conflict.} other {{versionConflicts} alerts could not be updated due to version conflicts.}}',
    values: {
      kibanaAlertWorkflowStatus,
      updated,
      versionConflicts
    }
  });
};
exports.UPDATED_ALERTS_WITH_VERSION_CONFLICTS = UPDATED_ALERTS_WITH_VERSION_CONFLICTS;