"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Welcome = void 0;
var _connector_setup = require("@kbn/elastic-assistant/impl/connectorland/connector_setup");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WelcomeComponent = () => {
  const title = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "emptyPromptTitleContainer",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptAvatar",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "welcomeTitle",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.WELCOME_TO_ATTACK_DISCOVERY))))), []);
  const body = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "bodyContainer",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "bodyText"
  }, i18n.FIRST_SET_UP))), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "welcome",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptContainer",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: body,
    title: title
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_connector_setup.ConnectorSetup, {
    onConversationUpdate: async () => {},
    updateConversationsOnSaveConnector: false // no conversation to update
  })));
};
WelcomeComponent.displayName = 'Welcome';
const Welcome = exports.Welcome = /*#__PURE__*/_react.default.memo(WelcomeComponent);