"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrimaryInteractions = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _subtitle = require("./subtitle");
var _title = require("./title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUBTITLE_LEFT_MARGIN = 77; // aligns with the schedule icon or title text, without adding to the height of the title

const PrimaryInteractionsComponent = ({
  attackDiscovery,
  isOpen,
  isSelected,
  onToggle,
  replacements,
  setIsOpen,
  setIsSelected,
  showAnonymized = false
}) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
  "data-test-subj": "primaryInteractions",
  direction: "column",
  gutterSize: "none",
  responsive: false,
  wrap: true
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react2.default.createElement(_title.Title, {
  attackDiscovery: attackDiscovery,
  isOpen: isOpen,
  isSelected: isSelected,
  onToggle: onToggle,
  replacements: replacements,
  setIsOpen: setIsOpen,
  setIsSelected: setIsSelected,
  showAnonymized: showAnonymized
})), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  css: (0, _react.css)`
        margin-left: ${SUBTITLE_LEFT_MARGIN}px;
      `,
  grow: false
}, /*#__PURE__*/_react2.default.createElement(_subtitle.Subtitle, {
  attackDiscovery: attackDiscovery
})));
PrimaryInteractionsComponent.displayName = 'PrimaryInteractions';
const PrimaryInteractions = exports.PrimaryInteractions = /*#__PURE__*/_react2.default.memo(PrimaryInteractionsComponent);