"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataFound = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _asset_inventory_title = require("../asset_inventory_title");
var _centered_wrapper = require("./centered_wrapper");
var _constants = require("../../constants");
var _integrations_light = _interopRequireDefault(require("../../../common/images/integrations_light.png"));
var _use_add_integration_path = require("./hooks/use_add_integration_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoDataFound = () => {
  const {
    addIntegrationPath,
    isLoading
  } = (0, _use_add_integration_path.useAddIntegrationPath)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_asset_inventory_title.AssetInventoryTitle, null), /*#__PURE__*/_react.default.createElement(_centered_wrapper.CenteredWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _constants.TEST_SUBJ_ONBOARDING_NO_DATA_FOUND,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      url: _integrations_light.default,
      size: "fullWidth",
      alt: _i18n.i18n.translate('xpack.securitySolution.assetInventory.emptyState.integrationsIllustrationAlt', {
        defaultMessage: 'Explore integrations'
      })
    }),
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.onboarding.startOnboardingAssets",
      defaultMessage: "Connect Sources to Discover Assets"
    })),
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.onboarding.startOnboardingAssetsDescription",
      defaultMessage: "It looks like there's no asset data available yet. To get started, connect your organization's data sources\u2014such as identity providers, cloud service providers, and other IT systems\u2014to populate your asset inventory."
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "fleetApp",
      size: "xl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "flexStart",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.initializing.exploreTitle",
      defaultMessage: "Explore Asset Discovery Integrations"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.initializing.exploreDescription",
      defaultMessage: "Discover assets across cloud, identity, and other environments for deeper visibility."
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "plusInCircle",
      href: addIntegrationPath,
      isDisabled: isLoading
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.initializing.addIntegration",
      defaultMessage: "Add integration"
    }))))
  }))));
};
exports.NoDataFound = NoDataFound;