"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetStarted = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _information_light = _interopRequireDefault(require("../../../common/images/information_light.png"));
var _asset_inventory_title = require("../asset_inventory_title");
var _centered_wrapper = require("./centered_wrapper");
var _hover_for_explanation_tooltip = require("./hover_for_explanation_tooltip");
var _empty_state_illustration_container = require("../empty_state_illustration_container");
var _use_enable_asset_inventory = require("./hooks/use_enable_asset_inventory");
var _constants = require("../../constants");
var _need_help = require("./need_help");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetStarted = () => {
  const {
    isEnabling,
    error,
    reset,
    enableAssetInventory
  } = (0, _use_enable_asset_inventory.useEnableAssetInventory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_asset_inventory_title.AssetInventoryTitle, null), /*#__PURE__*/_react.default.createElement(_centered_wrapper.CenteredWrapper, null, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.errorTitle",
      defaultMessage: "Unable to show your Inventory"
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.errorDescription",
      defaultMessage: "Something went wrong while setting things up. You can try again or go back to Get Started with Inventory."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "center",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: enableAssetInventory,
      fill: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.error.tryAgain",
      defaultMessage: "Try again"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: reset,
      iconType: "arrowLeft",
      iconSide: "left"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.error.backToStart",
      defaultMessage: "Back to Get Started with Inventory"
    })))))
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _constants.TEST_SUBJ_ONBOARDING_GET_STARTED,
    icon: /*#__PURE__*/_react.default.createElement(_empty_state_illustration_container.EmptyStateIllustrationContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      url: _information_light.default,
      size: "fullWidth",
      alt: _i18n.i18n.translate('xpack.securitySolution.assetInventory.emptyState.illustrationAlt', {
        defaultMessage: 'No results'
      })
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.getStarted.title",
      defaultMessage: "Get Started with Asset Inventory"
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description",
      defaultMessage: "Asset Inventory provides a unified view of all your organizations assets in one place. See everything detected by Elastic Security \u2014 whether from logs, {identity_providers}, {cloud_services}, {mdms} or configuration {databases} \u2014 all in a structured, searchable inventory. Enable Asset Inventory to gain complete visibility across your environment.",
      values: {
        identity_providers: /*#__PURE__*/_react.default.createElement(_hover_for_explanation_tooltip.HoverForExplanationTooltip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.identityProviders.helperText",
            defaultMessage: "Identity providers are services that store and manage user identities."
          })
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.identityProviders",
          defaultMessage: "identity providers"
        })),
        cloud_services: /*#__PURE__*/_react.default.createElement(_hover_for_explanation_tooltip.HoverForExplanationTooltip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.cloudServices.helperText",
            defaultMessage: "Cloud services are services that provide cloud-based infrastructure, platforms, or software."
          })
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.cloudServices",
          defaultMessage: "cloud services"
        })),
        mdms: /*#__PURE__*/_react.default.createElement(_hover_for_explanation_tooltip.HoverForExplanationTooltip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.mdms.helperText",
            defaultMessage: "Mobile Device Managers (MDMs) are services that manage mobile devices."
          })
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, 'MDMs')),
        databases: /*#__PURE__*/_react.default.createElement(_hover_for_explanation_tooltip.HoverForExplanationTooltip, {
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.databases.helperText",
            defaultMessage: "Databases are services that store and manage data."
          })
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.onboarding.getStarted.description.databases",
          defaultMessage: "databases"
        }))
      }
    }))),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: enableAssetInventory,
      iconType: "plusInCircle",
      isLoading: isEnabling
    }, isEnabling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.emptyState.enableAssetInventory.loading",
      defaultMessage: "Enabling Asset Inventory"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.emptyState.enableAssetInventory",
      defaultMessage: "Enable Asset Inventory"
    }))],
    footer: /*#__PURE__*/_react.default.createElement(_need_help.NeedHelp, null)
  }))));
};
exports.GetStarted = GetStarted;