"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assert = assert;
exports.isAssetInput = exports.hasPolicyTemplateInputs = exports.hasErrors = exports.getTemplateUrlFromPackageInfo = exports.getPolicyTemplateInputOptions = exports.getKibanaComponentId = exports.getDeploymentIdFromUrl = exports.getDefaultGcpHiddenVars = exports.getDefaultCloudCredentialsType = exports.getDefaultAzureCredentialsType = exports.getDefaultAwsCredentialsType = exports.getCloudProviderFromCloudHost = exports.getCloudProvider = exports.getCloudDefaultAwsCredentialConfig = exports.getCloudCredentialVarsConfig = exports.getCloudConnectorRemoteRoleTemplate = exports.getAwsCredentialsType = exports.getAssetPolicy = exports.getAssetInputHiddenVars = exports.getAssetCloudShellDefaultValue = exports.getAssetCloudFormationDefaultValue = exports.getArmTemplateUrlFromAssetPackage = exports.findVariableDef = exports.fieldIsInvalid = void 0;
var _public = require("@kbn/fleet-plugin/public");
var _merge = _interopRequireDefault(require("lodash/merge"));
var _std = require("@kbn/std");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _aws_credentials_form_options = require("./aws_credentials_form/aws_credentials_form_options");
var _gcp_credential_form = require("./gcp_credentials_form/gcp_credential_form");
var _google_cloud_logo = _interopRequireDefault(require("./assets/icons/google_cloud_logo.svg"));
var _constants2 = require("./aws_credentials_form/constants");
var _constants3 = require("./gcp_credentials_form/constants");
var _constants4 = require("./azure_credentials_form/constants");
var _test_subjects = require("./test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function assert(condition, message) {
  if (!condition) {
    throw new Error(message);
  }
}
const isAssetInput = input => _constants.SUPPORTED_CLOUDBEAT_INPUTS.includes(input.type);
exports.isAssetInput = isAssetInput;
const getAssetType = policyTemplateInput => {
  switch (policyTemplateInput) {
    case _constants2.CLOUDBEAT_AWS:
    case _constants4.CLOUDBEAT_AZURE:
    case _constants3.CLOUDBEAT_GCP:
      return 'asset_inventory';
    default:
      return 'n/a';
  }
};
const getDeploymentType = policyTemplateInput => {
  switch (policyTemplateInput) {
    case _constants2.CLOUDBEAT_AWS:
      return 'aws';
    case _constants4.CLOUDBEAT_AZURE:
      return 'azure';
    case _constants3.CLOUDBEAT_GCP:
      return 'gcp';
    default:
      return 'n/a';
  }
};
const getAssetInput = (input, inputType, inputVars) => {
  const isInputEnabled = input.type === inputType;
  return {
    ...input,
    enabled: isInputEnabled,
    streams: input.streams.map(stream => ({
      ...stream,
      enabled: isInputEnabled,
      // Merge new vars with existing vars
      ...(isInputEnabled && inputVars && {
        vars: {
          ...stream.vars,
          ...inputVars
        }
      })
    }))
  };
};

/**
 * Get a new object with the updated policy input and vars
 */
const getAssetPolicy = (newPolicy, inputType, inputVars) => ({
  ...newPolicy,
  namespace: _constants.ASSET_NAMESPACE,
  // Enable new policy input and disable all others
  inputs: newPolicy.inputs.map(item => getAssetInput(item, inputType, inputVars)),
  // Set hidden policy vars
  vars: (0, _merge.default)({}, newPolicy.vars, {
    deployment: {
      value: getDeploymentType(inputType)
    },
    asset: {
      value: getAssetType(inputType)
    }
  })
});
exports.getAssetPolicy = getAssetPolicy;
// type guard for checking inputs
const hasPolicyTemplateInputs = policyTemplate => {
  return Object.hasOwn(policyTemplate, 'inputs');
};
exports.hasPolicyTemplateInputs = hasPolicyTemplateInputs;
const getAssetCloudFormationDefaultValue = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const policyTemplate = packageInfo.policy_templates.find(p => p.name === _constants.ASSET_POLICY_TEMPLATE);
  if (!policyTemplate) return '';
  const policyTemplateInputs = hasPolicyTemplateInputs(policyTemplate) && policyTemplate.inputs;
  if (!policyTemplateInputs) return '';
  const cloudFormationTemplate = policyTemplateInputs.reduce((acc, input) => {
    var _input$vars$find;
    if (!input.vars) return acc;
    const template = (_input$vars$find = input.vars.find(v => v.name === 'cloud_formation_template')) === null || _input$vars$find === void 0 ? void 0 : _input$vars$find.default;
    return template ? String(template) : acc;
  }, '');
  return cloudFormationTemplate;
};
exports.getAssetCloudFormationDefaultValue = getAssetCloudFormationDefaultValue;
const getDefaultAwsCredentialsType = (packageInfo, setupTechnology) => {
  if (setupTechnology && setupTechnology === _public.SetupTechnology.AGENTLESS) {
    return _aws_credentials_form_options.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE;
  }
  const hasCloudFormationTemplate = !!getAssetCloudFormationDefaultValue(packageInfo);
  if (hasCloudFormationTemplate) {
    return _aws_credentials_form_options.DEFAULT_AWS_CREDENTIALS_TYPE;
  }
  return _aws_credentials_form_options.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE;
};
exports.getDefaultAwsCredentialsType = getDefaultAwsCredentialsType;
const getDefaultAzureCredentialsType = (packageInfo, setupTechnology) => {
  if (setupTechnology && setupTechnology === _public.SetupTechnology.AGENTLESS) {
    return _constants4.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_SECRET;
  }
  return _constants4.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE;
};
exports.getDefaultAzureCredentialsType = getDefaultAzureCredentialsType;
const getArmTemplateUrlFromAssetPackage = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const policyTemplate = packageInfo.policy_templates.find(p => p.name === _constants.ASSET_POLICY_TEMPLATE);
  if (!policyTemplate) return '';
  const policyTemplateInputs = hasPolicyTemplateInputs(policyTemplate) && policyTemplate.inputs;
  if (!policyTemplateInputs) return '';
  const armTemplateUrl = policyTemplateInputs.reduce((acc, input) => {
    var _input$vars$find2;
    if (!input.vars) return acc;
    const template = (_input$vars$find2 = input.vars.find(v => v.name === 'arm_template_url')) === null || _input$vars$find2 === void 0 ? void 0 : _input$vars$find2.default;
    return template ? String(template) : acc;
  }, '');
  return armTemplateUrl;
};
exports.getArmTemplateUrlFromAssetPackage = getArmTemplateUrlFromAssetPackage;
const getDefaultGcpHiddenVars = (packageInfo, setupTechnology) => {
  if (setupTechnology && setupTechnology === _public.SetupTechnology.AGENTLESS) {
    return {
      'gcp.credentials.type': {
        value: _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_JSON,
        type: 'text'
      }
    };
  }
  const hasCloudShellUrl = !!getAssetCloudShellDefaultValue(packageInfo);
  if (hasCloudShellUrl) {
    return {
      'gcp.credentials.type': {
        value: _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_NONE,
        type: 'text'
      }
    };
  }
  return {
    'gcp.credentials.type': {
      value: _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_FILE,
      type: 'text'
    }
  };
};
exports.getDefaultGcpHiddenVars = getDefaultGcpHiddenVars;
const getCloudDefaultAwsCredentialConfig = ({
  isAgentless,
  showCloudConnectors,
  packageInfo
}) => {
  let credentialsType;
  const hasCloudFormationTemplate = !!getAssetCloudFormationDefaultValue(packageInfo);
  if (!showCloudConnectors && isAgentless) {
    credentialsType = _aws_credentials_form_options.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE;
  } else if (showCloudConnectors && isAgentless) {
    credentialsType = _aws_credentials_form_options.DEFAULT_AGENTLESS_CLOUD_CONNECTORS_AWS_CREDENTIALS_TYPE;
  } else if (hasCloudFormationTemplate && !isAgentless) {
    credentialsType = _aws_credentials_form_options.DEFAULT_AWS_CREDENTIALS_TYPE;
  } else {
    credentialsType = _aws_credentials_form_options.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE;
  }
  const config = {
    'aws.credentials.type': {
      value: credentialsType,
      type: 'text'
    },
    ...(showCloudConnectors && {
      'aws.supports_cloud_connectors': {
        value: showCloudConnectors,
        type: 'bool'
      }
    })
  };
  return config;
};

/**
 * Input vars that are hidden from the user
 */
exports.getCloudDefaultAwsCredentialConfig = getCloudDefaultAwsCredentialConfig;
const getAssetInputHiddenVars = (inputType, packageInfo, setupTechnology, showCloudConnectors) => {
  switch (inputType) {
    case _constants2.CLOUDBEAT_AWS:
      return getCloudDefaultAwsCredentialConfig({
        isAgentless: setupTechnology === _public.SetupTechnology.AGENTLESS,
        packageInfo,
        showCloudConnectors
      });
    case _constants4.CLOUDBEAT_AZURE:
      return {
        'azure.credentials.type': {
          value: getDefaultAzureCredentialsType(packageInfo, setupTechnology),
          type: 'text'
        }
      };
    case _constants3.CLOUDBEAT_GCP:
      return getDefaultGcpHiddenVars(packageInfo, setupTechnology);
    default:
      return undefined;
  }
};
exports.getAssetInputHiddenVars = getAssetInputHiddenVars;
const assetInventoryCloudServiceProviders = [{
  type: _constants2.CLOUDBEAT_AWS,
  name: _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.googleCloudShellCredentials.awsOption.nameTitle', {
    defaultMessage: 'AWS'
  }),
  benchmark: _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.googleCloudShellCredentials.awsOption.benchmarkTitle', {
    defaultMessage: 'CAI AWS'
  }),
  icon: 'logoAWS',
  testId: _test_subjects.CAI_AWS_OPTION_TEST_SUBJ
}, {
  type: _constants3.CLOUDBEAT_GCP,
  name: _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.googleCloudShellCredentials.gcpOption.nameTitle', {
    defaultMessage: 'GCP'
  }),
  benchmark: _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.googleCloudShellCredentials.gcpOption.benchmarkTitle', {
    defaultMessage: 'CAI GCP'
  }),
  icon: _google_cloud_logo.default,
  testId: _test_subjects.CAI_GCP_OPTION_TEST_SUBJ
}, {
  type: _constants4.CLOUDBEAT_AZURE,
  name: _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.googleCloudShellCredentials.azureOption.nameTitle', {
    defaultMessage: 'Azure'
  }),
  benchmark: _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.googleCloudShellCredentials.azureOption.benchmarkTitle', {
    defaultMessage: 'CAI Azure'
  }),
  icon: 'logoAzure',
  testId: _test_subjects.CAI_AZURE_OPTION_TEST_SUBJ
}];
const getPolicyTemplateInputOptions = () => assetInventoryCloudServiceProviders.map(o => ({
  tooltip: o.tooltip,
  value: o.type,
  id: o.type,
  label: o.name,
  icon: o.icon,
  disabled: o.disabled,
  isBeta: o.isBeta,
  testId: o.testId
}));
exports.getPolicyTemplateInputOptions = getPolicyTemplateInputOptions;
const getAssetCloudShellDefaultValue = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const policyTemplate = packageInfo.policy_templates.find(p => p.name === _constants.ASSET_POLICY_TEMPLATE);
  if (!policyTemplate) return '';
  const policyTemplateInputs = hasPolicyTemplateInputs(policyTemplate) && policyTemplate.inputs;
  if (!policyTemplateInputs) return '';
  const cloudShellUrl = policyTemplateInputs.reduce((acc, input) => {
    var _input$vars$find3;
    if (!input.vars) return acc;
    const template = (_input$vars$find3 = input.vars.find(v => v.name === 'cloud_shell_url')) === null || _input$vars$find3 === void 0 ? void 0 : _input$vars$find3.default;
    return template ? String(template) : acc;
  }, '');
  return cloudShellUrl;
};
exports.getAssetCloudShellDefaultValue = getAssetCloudShellDefaultValue;
const getAwsCredentialsType = input => {
  var _input$streams$0$vars;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : _input$streams$0$vars['aws.credentials.type'].value;
};
exports.getAwsCredentialsType = getAwsCredentialsType;
const getDefaultCloudCredentialsType = (isAgentless, inputType) => {
  const credentialsTypes = {
    'cloudbeat/asset_inventory_aws': {
      'aws.credentials.type': {
        value: isAgentless ? _constants2.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS : _constants2.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION,
        type: 'text'
      }
    },
    'cloudbeat/asset_inventory_gcp': {
      'gcp.credentials.type': {
        value: isAgentless ? _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_JSON : _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_NONE,
        type: 'text'
      }
    },
    'cloudbeat/asset_inventory_azure': {
      'azure.credentials.type': {
        value: isAgentless ? _constants4.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_SECRET : _constants4.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE,
        type: 'text'
      }
    }
  };
  return credentialsTypes[inputType];
};

/**
 * Searches for a variable definition in a given packageInfo object based on a specified key.
 * It navigates through nested arrays within the packageInfo object to locate the variable definition associated with the provided key.
 * If found, it returns the variable definition object; otherwise, it returns undefined.
 */
exports.getDefaultCloudCredentialsType = getDefaultCloudCredentialsType;
const findVariableDef = (packageInfo, key) => {
  var _packageInfo$data_str;
  return packageInfo === null || packageInfo === void 0 ? void 0 : (_packageInfo$data_str = packageInfo.data_streams) === null || _packageInfo$data_str === void 0 ? void 0 : _packageInfo$data_str.filter(datastreams => datastreams !== undefined).map(ds => ds.streams).filter(streams => streams !== undefined).flat().filter(streams => (streams === null || streams === void 0 ? void 0 : streams.vars) !== undefined).map(cis => cis === null || cis === void 0 ? void 0 : cis.vars).flat().find(vars => (vars === null || vars === void 0 ? void 0 : vars.name) === key);
};
exports.findVariableDef = findVariableDef;
const fieldIsInvalid = (value, hasInvalidRequiredVars) => hasInvalidRequiredVars && !value;
exports.fieldIsInvalid = fieldIsInvalid;
const hasErrors = validationResults => {
  if (!validationResults) return 0;
  const flattenedValidation = (0, _std.getFlattenedObject)(validationResults);
  const errors = Object.values(flattenedValidation).filter(value => Boolean(value)) || [];
  return errors.length;
};
exports.hasErrors = hasErrors;
const getTemplateUrlFromPackageInfo = (packageInfo, integrationType, templateUrlFieldName) => {
  if (!(packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates)) return undefined;
  const policyTemplate = packageInfo.policy_templates.find(p => p.name === integrationType);
  if (!policyTemplate) return undefined;
  if ('inputs' in policyTemplate) {
    var _policyTemplate$input;
    const cloudFormationTemplate = (_policyTemplate$input = policyTemplate.inputs) === null || _policyTemplate$input === void 0 ? void 0 : _policyTemplate$input.reduce((acc, input) => {
      var _input$vars$find4;
      if (!input.vars) return acc;
      const template = (_input$vars$find4 = input.vars.find(v => v.name === templateUrlFieldName)) === null || _input$vars$find4 === void 0 ? void 0 : _input$vars$find4.default;
      return template ? String(template) : acc;
    }, '');
    return cloudFormationTemplate !== '' ? cloudFormationTemplate : undefined;
  }
};
exports.getTemplateUrlFromPackageInfo = getTemplateUrlFromPackageInfo;
const getCloudProvider = type => {
  if (type.includes('aws')) return 'aws';
  if (type.includes('azure')) return 'azure';
  if (type.includes('gcp')) return 'gcp';
  return undefined;
};
exports.getCloudProvider = getCloudProvider;
const getCloudCredentialVarsConfig = ({
  setupTechnology,
  optionId,
  showCloudConnectors,
  inputType
}) => {
  const supportsCloudConnector = setupTechnology === _public.SetupTechnology.AGENTLESS && optionId === _constants2.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS && showCloudConnectors;
  const credentialType = `${getCloudProvider(inputType)}.credentials.type`;
  const supportCloudConnectors = `${getCloudProvider(inputType)}.supports_cloud_connectors`;
  if (showCloudConnectors) {
    return {
      [credentialType]: {
        value: optionId
      },
      [supportCloudConnectors]: {
        value: supportsCloudConnector
      }
    };
  }
  return {
    [credentialType]: {
      value: optionId
    }
  };
};
exports.getCloudCredentialVarsConfig = getCloudCredentialVarsConfig;
const getCloudProviderFromCloudHost = cloudHost => {
  if (!cloudHost) return undefined;
  const match = cloudHost.match(/\b(aws|gcp|azure)\b/);
  return match === null || match === void 0 ? void 0 : match[1];
};
exports.getCloudProviderFromCloudHost = getCloudProviderFromCloudHost;
const getDeploymentIdFromUrl = url => {
  if (!url) return undefined;
  const match = url.match(/\/deployments\/([^/?#]+)/);
  return match === null || match === void 0 ? void 0 : match[1];
};
exports.getDeploymentIdFromUrl = getDeploymentIdFromUrl;
const getKibanaComponentId = cloudId => {
  if (!cloudId) return undefined;
  const base64Part = cloudId.split(':')[1];
  const decoded = atob(base64Part);
  const [,, kibanaComponentId] = decoded.split('$');
  return kibanaComponentId || undefined;
};
exports.getKibanaComponentId = getKibanaComponentId;
const getCloudConnectorRemoteRoleTemplate = ({
  input,
  cloud,
  packageInfo
}) => {
  var _input$streams$0$vars2, _input$streams, _input$streams$, _input$streams$$vars, _input$streams$$vars$, _cloud$serverless, _getTemplateUrlFromPa, _getTemplateUrlFromPa2;
  let elasticResourceId;
  const accountType = (_input$streams$0$vars2 = input === null || input === void 0 ? void 0 : (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$ = _input$streams[0]) === null || _input$streams$ === void 0 ? void 0 : (_input$streams$$vars = _input$streams$.vars) === null || _input$streams$$vars === void 0 ? void 0 : (_input$streams$$vars$ = _input$streams$$vars['aws.account_type']) === null || _input$streams$$vars$ === void 0 ? void 0 : _input$streams$$vars$.value) !== null && _input$streams$0$vars2 !== void 0 ? _input$streams$0$vars2 : _constants2.AWS_SINGLE_ACCOUNT;
  const provider = getCloudProviderFromCloudHost(cloud === null || cloud === void 0 ? void 0 : cloud.cloudHost);
  if (!provider || provider !== 'aws') return undefined;
  const deploymentId = getDeploymentIdFromUrl(cloud === null || cloud === void 0 ? void 0 : cloud.deploymentUrl);
  const kibanaComponentId = getKibanaComponentId(cloud === null || cloud === void 0 ? void 0 : cloud.cloudId);
  if (cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled && cloud !== null && cloud !== void 0 && (_cloud$serverless = cloud.serverless) !== null && _cloud$serverless !== void 0 && _cloud$serverless.projectId) {
    elasticResourceId = cloud.serverless.projectId;
  }
  if (cloud !== null && cloud !== void 0 && cloud.isCloudEnabled && deploymentId && kibanaComponentId) {
    elasticResourceId = kibanaComponentId;
  }
  if (!elasticResourceId) return undefined;
  return (_getTemplateUrlFromPa = getTemplateUrlFromPackageInfo(packageInfo, input.policy_template, _constants.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.CLOUD_FORMATION_CLOUD_CONNECTORS)) === null || _getTemplateUrlFromPa === void 0 ? void 0 : (_getTemplateUrlFromPa2 = _getTemplateUrlFromPa.replace(_constants.TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR, accountType)) === null || _getTemplateUrlFromPa2 === void 0 ? void 0 : _getTemplateUrlFromPa2.replace(_constants.TEMPLATE_URL_ELASTIC_RESOURCE_ID_ENV_VAR, elasticResourceId);
};
exports.getCloudConnectorRemoteRoleTemplate = getCloudConnectorRemoteRoleTemplate;