"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputVarsFields = exports.getAzureCredentialsFormOptions = exports.getAzureCredentialsFormManualOptions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _test_subjects = require("../test_subjects");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAzureCredentialsFormManualOptions = () => {
  return Object.entries(getAzureCredentialsFormOptions()).map(([key, value]) => ({
    value: key,
    text: value.label
  })).filter(({
    value
  }) => value !== _constants.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE &&
  // we remove this in order to hide it from the selectable options in the manual drop down
  value !== _constants.AZURE_CREDENTIALS_TYPE.MANUAL &&
  // TODO: remove 'manual' for stack version 8.13
  value !== _constants.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_USERNAME_AND_PASSWORD // this option is temporarily hidden
  );
};
exports.getAzureCredentialsFormManualOptions = getAzureCredentialsFormManualOptions;
const getInputVarsFields = (input, fields) => Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
  const field = fields[id];
  return {
    id,
    label: field.label,
    type: field.type || 'text',
    testSubj: field.testSubj,
    value: inputVar.value,
    isSecret: field === null || field === void 0 ? void 0 : field.isSecret
  };
});
exports.getInputVarsFields = getInputVarsFields;
const I18N_TENANT_ID = _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.tenantIdLabel', {
  defaultMessage: 'Tenant ID'
});
const I18N_CLIENT_ID = _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.clientIdLabel', {
  defaultMessage: 'Client ID'
});
const getAzureCredentialsFormOptions = () => ({
  [_constants.AZURE_CREDENTIALS_TYPE.MANAGED_IDENTITY]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.credentialType.managedIdentityLabel', {
      defaultMessage: 'Managed Identity'
    }),
    info: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.credentialType.managedIdentityInfo",
      defaultMessage: "Ensure the agent is deployed on a resource that supports managed identities (e.g., Azure Virtual Machines). No explicit credentials need to be provided; Azure handles the authentication."
    })),
    fields: {}
  },
  [_constants.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE]: {
    label: 'ARM Template',
    info: [],
    fields: {}
  },
  // TODO: remove for stack version 8.13
  [_constants.AZURE_CREDENTIALS_TYPE.MANUAL]: {
    label: 'Manual',
    info: [],
    fields: {}
  },
  [_constants.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_SECRET]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.servicePrincipalWithClientSecretLabel', {
      defaultMessage: 'Service principal with Client Secret'
    }),
    fields: {
      'azure.credentials.tenant_id': {
        label: I18N_TENANT_ID,
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.TENANT_ID
      },
      'azure.credentials.client_id': {
        label: I18N_CLIENT_ID,
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.CLIENT_ID
      },
      'azure.credentials.client_secret': {
        type: 'password',
        isSecret: true,
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.clientSecretLabel', {
          defaultMessage: 'Client Secret'
        }),
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.CLIENT_SECRET
      }
    }
  },
  [_constants.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_CERTIFICATE]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.servicePrincipalWithClientCertificateLabel', {
      defaultMessage: 'Service principal with Client Certificate'
    }),
    fields: {
      'azure.credentials.tenant_id': {
        label: I18N_TENANT_ID,
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.TENANT_ID
      },
      'azure.credentials.client_id': {
        label: I18N_CLIENT_ID,
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.CLIENT_ID
      },
      'azure.credentials.client_certificate_path': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.clientCertificatePathLabel', {
          defaultMessage: 'Client Certificate Path'
        }),
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.CLIENT_CERTIFICATE_PATH
      },
      'azure.credentials.client_certificate_password': {
        type: 'password',
        isSecret: true,
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.clientCertificatePasswordLabel', {
          defaultMessage: 'Client Certificate Password'
        }),
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.CLIENT_CERTIFICATE_PASSWORD
      }
    }
  },
  [_constants.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_USERNAME_AND_PASSWORD]: {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.servicePrincipalWithClientUsernameAndPasswordLabel', {
      defaultMessage: 'Service principal with Client Username and Password'
    }),
    fields: {
      'azure.credentials.tenant_id': {
        label: I18N_TENANT_ID,
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.TENANT_ID
      },
      'azure.credentials.client_id': {
        label: I18N_CLIENT_ID,
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.CLIENT_ID
      },
      'azure.credentials.client_username': {
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.clientUsernameLabel', {
          defaultMessage: 'Client Username'
        }),
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.CLIENT_USERNAME
      },
      'azure.credentials.client_password': {
        type: 'password',
        isSecret: true,
        label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.azureIntegration.clientPasswordLabel', {
          defaultMessage: 'Client Password'
        }),
        testSubj: _test_subjects.CAI_AZURE_INPUT_FIELDS_TEST_SUBJECTS.CLIENT_PASSWORD
      }
    }
  }
});
exports.getAzureCredentialsFormOptions = getAzureCredentialsFormOptions;