"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoresPreviewResponse = exports.RiskScoresPreviewRequest = exports.PreviewRiskScoreResponse = exports.PreviewRiskScoreRequestBody = void 0;
var _zod = require("@kbn/zod");
var _common = require("../common/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Risk Scoring API
 *   version: 1
 */

const RiskScoresPreviewRequest = exports.RiskScoresPreviewRequest = _zod.z.object({
  /**
   * The identifier of the Kibana data view to be used when generating risk scores. If a data view is not found, the provided ID will be used as the query's index pattern instead.
   */
  data_view_id: _common.DataViewId,
  /**
   * Used to retrieve a specific "page" of risk scores. If unspecified, the first "page" of scores is returned. See also the `after_keys` key in a risk scores response.
   */
  after_keys: _common.AfterKeys.optional(),
  /**
   * If set to `true`, a `debug` key is added to the response, containing both the internal request and response with elasticsearch.
   */
  debug: _zod.z.boolean().optional(),
  /**
   * An elasticsearch DSL filter object. Used to filter the data being scored, which implicitly filters the risk scores returned.
   */
  filter: _common.Filter.optional(),
  page_size: _common.PageSize.optional(),
  /**
   * Used to restrict the type of risk scores involved. If unspecified, both `host` and `user` scores will be returned.
   */
  identifier_type: _common.IdentifierType.optional(),
  /**
   * Defines the time period over which scores will be evaluated. If unspecified, a range of `[now, now-30d]` will be used.
   */
  range: _common.DateRange.optional(),
  weights: _common.RiskScoreWeights.optional(),
  /**
   * A list of alert statuses to exclude from the risk score calculation. If unspecified, all alert statuses are included.
   */
  exclude_alert_statuses: _zod.z.array(_zod.z.string()).optional(),
  /**
   * A list of alert tags to exclude from the risk score calculation. If unspecified, all alert tags are included.
   */
  exclude_alert_tags: _zod.z.array(_zod.z.string()).optional()
});
const RiskScoresPreviewResponse = exports.RiskScoresPreviewResponse = _zod.z.object({
  /**
   * Used to obtain the next "page" of risk scores. See also the `after_keys` key in a risk scores request. If this key is empty, the calculation is complete.
   */
  after_keys: _common.AfterKeys,
  /**
   * Object containing debug information, particularly the internal request and response from elasticsearch
   */
  debug: _zod.z.object({
    request: _zod.z.string().optional(),
    response: _zod.z.string().optional()
  }).optional(),
  scores: _zod.z.object({
    /**
     * A list of host risk scores
     */
    host: _zod.z.array(_common.EntityRiskScoreRecord).optional(),
    /**
     * A list of user risk scores
     */
    user: _zod.z.array(_common.EntityRiskScoreRecord).optional(),
    /**
     * A list of service risk scores
     */
    service: _zod.z.array(_common.EntityRiskScoreRecord).optional(),
    /**
     * A list of generic entities risk scores
     */
    generic: _zod.z.array(_common.EntityRiskScoreRecord).optional()
  })
});
const PreviewRiskScoreRequestBody = exports.PreviewRiskScoreRequestBody = RiskScoresPreviewRequest;
const PreviewRiskScoreResponse = exports.PreviewRiskScoreResponse = RiskScoresPreviewResponse;