"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleEditorPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _json_rule_editor = require("./json_rule_editor");
var _visual_rule_editor = require("./visual_rule_editor");
var _model = require("../../model");
var _role_mapping_constants = require("../services/role_mapping_constants");
var _role_mapping_validation = require("../services/role_mapping_validation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleEditorPanel extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "conditionallyRenderEditModeToggle", () => {
      if (!this.props.readOnly) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.getModeToggle(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }));
      }
    });
    (0, _defineProperty2.default)(this, "initializeFromRawRules", rawRules => {
      const {
        rules,
        maxDepth
      } = (0, _model.generateRulesFromRaw)(rawRules);
      const mode = maxDepth >= _role_mapping_constants.VISUAL_MAX_RULE_DEPTH ? 'json' : 'visual';
      return {
        rules,
        mode,
        maxDepth
      };
    });
    (0, _defineProperty2.default)(this, "getConfirmModeChangePrompt", confirmModalTitleId => {
      if (!this.state.showConfirmModeChange) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "aria-labelledby": confirmModalTitleId,
        titleProps: {
          id: confirmModalTitleId
        },
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.confirmModeChangePromptTitle",
          defaultMessage: "Switch with invalid rules?"
        }),
        onCancel: () => this.setState({
          showConfirmModeChange: false
        }),
        onConfirm: () => {
          this.setState({
            mode: 'visual',
            showConfirmModeChange: false
          });
          this.onValidityChange(true);
        },
        cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.confirmModeChangePromptCancelButton",
          defaultMessage: "Cancel"
        }),
        confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.confirmModeChangePromptConfirmButton",
          defaultMessage: "Switch anyway"
        })
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.confirmModeChangePromptBody",
        defaultMessage: "The rules defined are not valid, and cannot be translated to the visual editor. You may lose some or all of your changes during the conversion. Do you wish to continue?"
      })));
    });
    (0, _defineProperty2.default)(this, "onRuleChange", updatedRule => {
      const raw = updatedRule ? updatedRule.toRaw() : {};
      this.props.onChange(raw);
      this.setState({
        ...(0, _model.generateRulesFromRaw)(raw)
      });
    });
    (0, _defineProperty2.default)(this, "onValidityChange", isRuleValid => {
      this.setState({
        isRuleValid
      });
      this.props.onValidityChange(isRuleValid);
    });
    (0, _defineProperty2.default)(this, "trySwitchEditorMode", newMode => {
      switch (newMode) {
        case 'visual':
          {
            if (this.state.isRuleValid) {
              this.setState({
                mode: newMode
              });
              this.onValidityChange(true);
            } else {
              this.setState({
                showConfirmModeChange: true
              });
            }
            break;
          }
        case 'json':
          this.setState({
            mode: newMode
          });
          this.onValidityChange(true);
          break;
        default:
          throw new Error(`Unexpected rule editor mode: ${this.state.mode}`);
      }
    });
    this.state = {
      ...this.initializeFromRawRules(props.rawRules),
      isRuleValid: true,
      showConfirmModeChange: false,
      showVisualEditorDisabledAlert: false
    };
  }
  render() {
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    const validationResult = this.props.validateForm && (0, _role_mapping_validation.validateRoleMappingRules)({
      rules: this.state.rules ? this.state.rules.toRaw() : {}
    });
    let validationWarning = null;
    if (validationResult && validationResult.error) {
      validationWarning = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        title: validationResult.error,
        size: "s"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.mappingRulesPanelTitle",
      defaultMessage: "Mapping rules"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.roleMappingRulesFormRowHelpText",
      defaultMessage: "Assign roles to users who match these rules. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: this.props.docLinks.links.security.mappingRolesFieldRules,
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.fieldRuleEditor.fieldValueHelp",
          defaultMessage: "Learn about supported field values."
        }))
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      isInvalid: validationResult && validationResult.isInvalid
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, validationWarning, this.conditionallyRenderEditModeToggle(), this.getEditor(), this.getConfirmModeChangePrompt(confirmModalTitleId)))))));
  }
  getModeToggle() {
    if (this.state.mode === 'json' && this.state.maxDepth > _role_mapping_constants.VISUAL_MAX_RULE_DEPTH) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        size: "s",
        title: _i18n.i18n.translate('xpack.security.management.editRoleMapping.visualEditorUnavailableTitle', {
          defaultMessage: 'Visual editor unavailable'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualEditorUnavailableMessage",
        defaultMessage: "Rule definition is too complex for the visual editor."
      }));
    }

    // Don't offer swith if no rules are present yet
    if (this.state.mode === 'visual' && this.state.rules === null) {
      return null;
    }
    switch (this.state.mode) {
      case 'visual':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "roleMappingsJSONRuleEditorButton",
          onClick: () => {
            this.trySwitchEditorMode('json');
          }
        }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.switchToJSONEditorLink",
          defaultMessage: "Switch to JSON editor"
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "inputOutput",
          size: "s"
        })));
      case 'json':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "roleMappingsVisualRuleEditorButton",
          onClick: () => {
            this.trySwitchEditorMode('visual');
          }
        }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.switchToVisualEditorLink",
          defaultMessage: "Switch to visual editor"
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "inputOutput",
          size: "s"
        })));
      default:
        throw new Error(`Unexpected rule editor mode: ${this.state.mode}`);
    }
  }
  getEditor() {
    switch (this.state.mode) {
      case 'visual':
        return /*#__PURE__*/_react.default.createElement(_visual_rule_editor.VisualRuleEditor, {
          "data-test-subj": "roleMappingsVisualRuleEditor",
          rules: this.state.rules,
          maxDepth: this.state.maxDepth,
          onChange: this.onRuleChange,
          onSwitchEditorMode: () => this.trySwitchEditorMode('json'),
          readOnly: this.props.readOnly
        });
      case 'json':
        return /*#__PURE__*/_react.default.createElement(_json_rule_editor.JSONRuleEditor, {
          "data-test-subj": "roleMappingsJSONRuleEditor",
          rules: this.state.rules,
          onChange: this.onRuleChange,
          onValidityChange: this.onValidityChange,
          readOnly: this.props.readOnly
        });
      default:
        throw new Error(`Unexpected rule editor mode: ${this.state.mode}`);
    }
  }
}
exports.RuleEditorPanel = RuleEditorPanel;
(0, _defineProperty2.default)(RuleEditorPanel, "defaultProps", {
  readOnly: false
});