"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSynonymsSetModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _synonyms_utils = require("../../utils/synonyms_utils");
var _use_put_synonyms_set = require("../../hooks/use_put_synonyms_set");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateSynonymsSetModal = ({
  onClose
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'createSynonymsSetModalTitle'
  });
  const formId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'createSynonymsSetModalForm'
  });
  const overwriteId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'createSynonymsSetModalOverwrite'
  });
  const [name, setName] = (0, _react.useState)('');
  const [rawName, setRawName] = (0, _react.useState)('');
  const [conflictError, setConflictError] = (0, _react.useState)(false);
  const [forceWrite, setForceWrite] = (0, _react.useState)(false);
  const {
    mutate: createSynonymsSet
  } = (0, _use_put_synonyms_set.usePutSynonymsSet)(() => {
    onClose();
  }, () => {
    setConflictError(true);
  });
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.createSynonymsSetModal.title",
    defaultMessage: "Name your synonyms set"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: formId,
    component: "form",
    onSubmit: e => {
      e.preventDefault();
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.new_set_created);
      createSynonymsSet({
        synonymsSetId: name,
        forceWrite
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.searchSynonyms.createSynonymsSetModal.nameLabel', {
      defaultMessage: 'Name'
    }),
    helpText: !!rawName && !conflictError ? _i18n.i18n.translate('xpack.searchSynonyms.createSynonymsSetModal.nameHelpText', {
      defaultMessage: 'Your synonyms set will be named: {name}',
      values: {
        name
      }
    }) : undefined,
    isInvalid: conflictError,
    error: conflictError ? _i18n.i18n.translate('xpack.searchSynonyms.createSynonymsSetModal.nameErrorText', {
      defaultMessage: 'A synonym set with id {name} already exists.',
      values: {
        name
      }
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "searchSynonymsCreateSynonymsSetModalFieldText",
    value: rawName,
    onChange: e => {
      setRawName(e.target.value);
      setName((0, _synonyms_utils.formatSynonymsSetName)(e.target.value));
      setConflictError(false);
      setForceWrite(false);
    }
  })), conflictError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: overwriteId,
    "data-test-subj": "searchSynonymsCreateSynonymsSetModalForceWrite",
    label: _i18n.i18n.translate('xpack.searchSynonyms.createSynonymsSetModal.forceWrite', {
      defaultMessage: 'Overwrite the existing synonym set.'
    }),
    checked: forceWrite,
    onChange: () => setForceWrite(!forceWrite)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchSynonymsCreateSynonymsSetModalCancelButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.createSynonymsSetModal.cancelButton",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchSynonymsCreateSynonymsSetModalCreateButton",
    form: formId,
    fill: true,
    disabled: !name || conflictError && !forceWrite,
    type: "submit"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.createSynonymsSetModal.createButton",
    defaultMessage: "Create"
  }))));
};
exports.CreateSynonymsSetModal = CreateSynonymsSetModal;