"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_ROUTE_ROOT = exports.APIRoutes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ROUTE_ROOT = exports.PLUGIN_ROUTE_ROOT = '/app/elasticsearch/synonyms';
let APIRoutes = exports.APIRoutes = /*#__PURE__*/function (APIRoutes) {
  APIRoutes["SYNONYM_SETS"] = "/internal/search_synonyms/synonyms";
  APIRoutes["SYNONYM_SET_ID"] = "/internal/search_synonyms/synonyms/{synonymsSetId}";
  APIRoutes["SYNONYM_SET_ID_RULE_ID"] = "/internal/search_synonyms/synonyms/{synonymsSetId}/{ruleId}";
  APIRoutes["GENERATE_SYNONYM_RULE_ID"] = "/internal/search_synonyms/synonyms/{synonymsSetId}/generate";
  APIRoutes["SYNONYM_SET_EXISTS"] = "/internal/search_synonyms/synonyms/{synonymsSetId}/exists";
  return APIRoutes;
}({});