"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleFlyoutRightPanel = exports.QueryRuleFlyoutPanel = exports.QueryRuleFlyoutBody = exports.DroppableContainer = exports.DraggableListHeader = exports.DocumentCountLabelStyle = exports.DocumentCountLabelContainer = exports.DocsColumnContainer = exports.ActionTypeIconBadgeContainer = exports.ActionHeaderContainer = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocsColumnContainer = theme => (0, _react.css)({
  minWidth: theme.base * 10
});
exports.DocsColumnContainer = DocsColumnContainer;
const ActionTypeIconBadgeContainer = theme => (0, _react.css)({
  minWidth: theme.base * 5,
  textAlign: 'end'
});
exports.ActionTypeIconBadgeContainer = ActionTypeIconBadgeContainer;
const DocumentCountLabelContainer = theme => (0, _react.css)({
  minWidth: theme.base * 4
});
exports.DocumentCountLabelContainer = DocumentCountLabelContainer;
const DocumentCountLabelStyle = theme => (0, _react.css)({
  minWidth: theme.size.l
});
exports.DocumentCountLabelStyle = DocumentCountLabelStyle;
const DraggableListHeader = theme => (0, _react.css)({
  padding: `0 ${theme.base * 2.25}px 0 ${theme.base * 1.5}px`
});
exports.DraggableListHeader = DraggableListHeader;
const ActionHeaderContainer = theme => (0, _react.css)({
  minWidth: theme.size.xl,
  textAlign: 'end'
});
exports.ActionHeaderContainer = ActionHeaderContainer;
const DroppableContainer = theme => (0, _react.css)({
  backgroundColor: theme.colors.backgroundBaseSubdued
});
exports.DroppableContainer = DroppableContainer;
const QueryRuleFlyoutBody = exports.QueryRuleFlyoutBody = (0, _react.css)({
  '.euiFlyoutBody__overflowContent': {
    height: '100%',
    padding: 0
  }
});
const QueryRuleFlyoutPanel = exports.QueryRuleFlyoutPanel = (0, _react.css)({
  height: '100%'
});
const QueryRuleFlyoutRightPanel = theme => (0, _react.css)({
  borderLeft: `1px solid ${theme.colors.lightShade}`
});
exports.QueryRuleFlyoutRightPanel = QueryRuleFlyoutRightPanel;