"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedPlaygroundFormResolver = exports.playgroundFormResolver = void 0;
var _types = require("../types");
var _user_query = require("./user_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REQUIRED_ERROR = {
  type: 'required'
};
const hasErrors = errors => Object.keys(errors).length > 0;
const playgroundFormResolver = async values => {
  const errors = {};
  if (!values[_types.PlaygroundFormFields.summarizationModel]) {
    errors[_types.PlaygroundFormFields.summarizationModel] = REQUIRED_ERROR;
  }
  if (!values[_types.PlaygroundFormFields.prompt]) {
    errors[_types.PlaygroundFormFields.prompt] = REQUIRED_ERROR;
  } else if (!values[_types.PlaygroundFormFields.prompt].trim()) {
    errors[_types.PlaygroundFormFields.prompt] = REQUIRED_ERROR;
  }
  if (!values[_types.PlaygroundFormFields.question]) {
    errors[_types.PlaygroundFormFields.question] = REQUIRED_ERROR;
  } else if (!values[_types.PlaygroundFormFields.question].trim()) {
    errors[_types.PlaygroundFormFields.question] = REQUIRED_ERROR;
  }
  const userQueryError = (0, _user_query.validateUserElasticsearchQuery)(values[_types.PlaygroundFormFields.userElasticsearchQuery]);
  if (userQueryError) {
    errors[_types.PlaygroundFormFields.userElasticsearchQuery] = userQueryError;
  }
  if (hasErrors(errors)) {
    return {
      values: {},
      errors
    };
  }
  return {
    values,
    errors: {}
  };
};
exports.playgroundFormResolver = playgroundFormResolver;
const savedPlaygroundFormResolver = async (values, context, options) => {
  const baseResult = await playgroundFormResolver(values, context, options);
  return baseResult;
};
exports.savedPlaygroundFormResolver = savedPlaygroundFormResolver;