"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointModelInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointModelInfo = ({
  endpointInfo
}) => {
  var _ELASTIC_MODEL_DEFINI, _ELASTIC_MODEL_DEFINI2;
  const serviceSettings = endpointInfo.service_settings;
  const modelId = 'model_id' in serviceSettings ? serviceSettings.model_id : 'model' in serviceSettings ? serviceSettings.model : undefined;
  const isEligibleForMITBadge = modelId && ((_ELASTIC_MODEL_DEFINI = _mlTrainedModelsUtils.ELASTIC_MODEL_DEFINITIONS[modelId]) === null || _ELASTIC_MODEL_DEFINI === void 0 ? void 0 : _ELASTIC_MODEL_DEFINI.license) === 'MIT';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, modelId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, modelId)), isEligibleForMITBadge ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "popout",
    iconSide: "right",
    href: (_ELASTIC_MODEL_DEFINI2 = _mlTrainedModelsUtils.ELASTIC_MODEL_DEFINITIONS[modelId].licenseUrl) !== null && _ELASTIC_MODEL_DEFINI2 !== void 0 ? _ELASTIC_MODEL_DEFINI2 : '',
    target: "_blank",
    "data-test-subj": 'mit-license-badge'
  }, i18n.MIT_LICENSE)) : null, ' ')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, endpointModelAtrributes(endpointInfo)));
};
exports.EndpointModelInfo = EndpointModelInfo;
function endpointModelAtrributes(endpoint) {
  switch (endpoint.service) {
    case _inferenceEndpointUiCommon.ServiceProviderKeys.hugging_face:
      return huggingFaceAttributes(endpoint);
    case _inferenceEndpointUiCommon.ServiceProviderKeys.azureaistudio:
      return azureOpenAIStudioAttributes(endpoint);
    case _inferenceEndpointUiCommon.ServiceProviderKeys.azureopenai:
      return azureOpenAIAttributes(endpoint);
    default:
      return null;
  }
}
function huggingFaceAttributes(endpoint) {
  const serviceSettings = endpoint.service_settings;
  const url = 'url' in serviceSettings ? serviceSettings.url : null;
  return url;
}
function azureOpenAIStudioAttributes(endpoint) {
  const serviceSettings = endpoint.service_settings;
  return 'provider' in serviceSettings ? serviceSettings === null || serviceSettings === void 0 ? void 0 : serviceSettings.provider : undefined;
}
function azureOpenAIAttributes(endpoint) {
  const serviceSettings = endpoint.service_settings;
  return 'resource_name' in serviceSettings ? serviceSettings.resource_name : undefined;
}