"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskTypeFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _multi_select_filter = require("./multi_select_filter");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TaskTypeFilter = ({
  optionKeys,
  onChange,
  uniqueTaskTypes
}) => {
  const filterId = 'type';
  const onSystemFilterChange = newOptions => {
    onChange({
      [filterId]: newOptions.filter(option => option.checked === 'on').map(option => option.key)
    });
  };
  const filteredOptions = (0, _react.useMemo)(() => {
    return [...uniqueTaskTypes].map(type => ({
      key: type,
      label: type
    }));
  }, [uniqueTaskTypes]);
  return /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: i18n.TASK_TYPE,
    onChange: onSystemFilterChange,
    options: filteredOptions,
    renderOption: option => option.label,
    selectedOptionKeys: optionKeys,
    dataTestSubj: "type-field-endpoints"
  });
};
exports.TaskTypeFilter = TaskTypeFilter;