"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDetailsData = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_index_mappings = require("../../hooks/api/use_index_mappings");
var _index_documents = require("../index_documents/index_documents");
var _details_search_example = require("./details_search_example");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexDetailsData = ({
  indexName,
  indexDocuments,
  isInitialLoading,
  navigateToPlayground,
  userPrivileges
}) => {
  var _indexDocuments$resul, _indexDocuments$resul2;
  const {
    data: mappingData
  } = (0, _use_index_mappings.useIndexMapping)(indexName);
  const documents = (_indexDocuments$resul = indexDocuments === null || indexDocuments === void 0 ? void 0 : (_indexDocuments$resul2 = indexDocuments.results) === null || _indexDocuments$resul2 === void 0 ? void 0 : _indexDocuments$resul2.data) !== null && _indexDocuments$resul !== void 0 ? _indexDocuments$resul : [];
  if (isInitialLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: false,
      hasShadow: false,
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      color: "primary"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, documents.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_details_search_example.IndexSearchExample, {
    indexName: indexName,
    documents: documents,
    mappings: mappingData,
    navigateToPlayground: navigateToPlayground
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_documents.IndexDocuments, {
    indexName: indexName,
    documents: documents,
    mappings: mappingData,
    userPrivileges: userPrivileges
  }))));
};
exports.IndexDetailsData = IndexDetailsData;