"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduledReportFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _reportingPublic = require("@kbn/reporting-public");
var _reportingCommon = require("@kbn/reporting-common");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _convert_to_rrule = require("@kbn/response-ops-recurring-schedule-form/utils/convert_to_rrule");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _recurring_schedule_form_fields = require("@kbn/response-ops-recurring-schedule-form/components/recurring_schedule_form_fields");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _rrule = require("@kbn/rrule");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _moment2 = require("@kbn/response-ops-recurring-schedule-form/converters/moment");
var _use_get_user_profile_query = require("../hooks/use_get_user_profile_query");
var _responsive_form_group = require("./responsive_form_group");
var _report_params = require("../report_params");
var _scheduled_report_form_schema = require("../schemas/scheduled_report_form_schema");
var _use_default_timezone = require("../hooks/use_default_timezone");
var _use_schedule_report = require("../hooks/use_schedule_report");
var _use_get_reporting_health_query = require("../hooks/use_get_reporting_health_query");
var i18n = _interopRequireWildcard(require("../translations"));
var _constants = require("../constants");
var _start_date_validator = require("../validators/start_date_validator");
var _UI_TIMEZONE_OPTIONS$;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const FormField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const TIMEZONE_OPTIONS = (_UI_TIMEZONE_OPTIONS$ = _coreUiSettingsCommon.TIMEZONE_OPTIONS.map(tz => ({
  inputDisplay: tz,
  value: tz
}))) !== null && _UI_TIMEZONE_OPTIONS$ !== void 0 ? _UI_TIMEZONE_OPTIONS$ : [{
  text: 'UTC',
  value: 'UTC'
}];
const ScheduledReportFlyoutContent = ({
  apiClient,
  objectType,
  sharingData,
  scheduledReport,
  availableReportTypes,
  onClose,
  readOnly = false
}) => {
  var _availableReportTypes;
  if (!readOnly && (!objectType || !sharingData)) {
    throw new Error('Cannot schedule an export without an objectType or sharingData');
  }
  const {
    application: {
      capabilities
    },
    http,
    actions: {
      validateEmailAddresses
    },
    notifications: {
      toasts
    },
    userProfile: userProfileService
  } = (0, _reportingPublic.useKibana)().services;
  const {
    data: userProfile,
    isLoading: isUserProfileLoading
  } = (0, _use_get_user_profile_query.useGetUserProfileQuery)({
    userProfileService
  });
  const {
    data: reportingHealth,
    isLoading: isReportingHealthLoading,
    isError: isReportingHealthError
  } = (0, _use_get_reporting_health_query.useGetReportingHealthQuery)({
    http
  });
  const hasManageReportingPrivilege = (0, _react.useMemo)(() => {
    if (!capabilities) {
      return false;
    }
    return capabilities.manageReporting.show === true;
  }, [capabilities]);
  const reportingPageLink = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: http.basePath.prepend(_reportingCommon.REPORTING_MANAGEMENT_SCHEDULES)
  }, i18n.REPORTING_PAGE_LINK_TEXT), [http.basePath]);
  const {
    mutateAsync: scheduleReport,
    isLoading: isScheduleExportLoading
  } = (0, _use_schedule_report.useScheduleReport)({
    http
  });
  const {
    defaultTimezone
  } = (0, _use_default_timezone.useDefaultTimezone)();
  const schema = (0, _react.useMemo)(() => (0, _scheduled_report_form_schema.getScheduledReportFormSchema)(validateEmailAddresses, availableReportTypes), [availableReportTypes, validateEmailAddresses]);
  const recurring = true;
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: scheduledReport,
    options: {
      stripEmptyFields: true
    },
    schema,
    onSubmit: async formData => {
      try {
        const {
          title,
          reportTypeId,
          startDate,
          timezone,
          recurringSchedule,
          optimizedForPrinting,
          sendByEmail,
          emailRecipients
        } = formData;
        const rrule = (0, _convert_to_rrule.convertToRRule)({
          startDate,
          timezone,
          recurringSchedule,
          includeTime: true
        });
        await scheduleReport({
          reportTypeId,
          jobParams: (0, _report_params.getReportParams)({
            apiClient,
            // The assertion at the top of the component ensures these are defined when scheduling
            sharingData: sharingData,
            objectType: objectType,
            title,
            reportTypeId,
            ...(reportTypeId === 'printablePdfV2' ? {
              optimizedForPrinting
            } : {})
          }),
          schedule: {
            rrule: rrule
          },
          notification: sendByEmail ? {
            email: {
              to: emailRecipients
            }
          } : undefined
        });
        toasts.addSuccess({
          title: i18n.SCHEDULED_REPORT_FORM_SUCCESS_TOAST_TITLE,
          text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SCHEDULED_REPORT_FORM_SUCCESS_TOAST_MESSAGE, " ", reportingPageLink, "."))
        });
      } catch (error) {
        // eslint-disable-next-line no-console
        console.error(error);
        toasts.addError(error, {
          title: i18n.SCHEDULED_REPORT_FORM_FAILURE_TOAST_TITLE,
          toastMessage: i18n.SCHEDULED_REPORT_FORM_FAILURE_TOAST_MESSAGE
        });
        // Forward error to signal whether to close the flyout or not
        throw error;
      }
    }
  });
  const [{
    reportTypeId,
    startDate,
    timezone,
    sendByEmail
  }] = (0, _hook_form_lib.useFormData)({
    form,
    watch: ['reportTypeId', 'startDate', 'timezone', 'sendByEmail']
  });
  const now = (0, _react.useMemo)(() => (0, _moment.default)().set({
    second: 0,
    millisecond: 0
  }), []);
  const defaultStartDateValue = (0, _react.useMemo)(() => now.toISOString(), [now]);
  (0, _react.useEffect)(() => {
    if (!readOnly && !hasManageReportingPrivilege && userProfile !== null && userProfile !== void 0 && userProfile.user.email) {
      form.setFieldValue('emailRecipients', [userProfile.user.email]);
    }
  }, [form, hasManageReportingPrivilege, readOnly, userProfile === null || userProfile === void 0 ? void 0 : userProfile.user.email]);
  const isRecurring = recurring || false;
  const isEmailActive = sendByEmail || false;
  const onSubmit = async () => {
    try {
      if (await form.validate()) {
        await form.submit();
        onClose();
      }
    } catch (e) {
      // Keep the flyout open in case of schedule error
    }
  };
  const hasUnmetPrerequisites = !(reportingHealth !== null && reportingHealth !== void 0 && reportingHealth.isSufficientlySecure) || !(reportingHealth !== null && reportingHealth !== void 0 && reportingHealth.hasPermanentEncryptionKey);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.SCHEDULED_REPORT_FLYOUT_TITLE, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    className: "eui-alignMiddle",
    iconType: "flask",
    label: i18n.TECH_PREVIEW_LABEL,
    tooltipContent: i18n.TECH_PREVIEW_DESCRIPTION
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, !readOnly && (isReportingHealthLoading || isUserProfileLoading) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }) : isReportingHealthError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.CANNOT_LOAD_REPORTING_HEALTH_TITLE,
    iconType: "error",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.CANNOT_LOAD_REPORTING_HEALTH_MESSAGE)) : hasUnmetPrerequisites ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.UNMET_REPORTING_PREREQUISITES_TITLE,
    iconType: "error",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.UNMET_REPORTING_PREREQUISITES_MESSAGE)) : /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    id: _constants.SCHEDULED_REPORT_FORM_ID
  }, /*#__PURE__*/_react.default.createElement(_responsive_form_group.ResponsiveFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.SCHEDULED_REPORT_FORM_DETAILS_SECTION_TITLE)
  }, /*#__PURE__*/_react.default.createElement(FormField, {
    path: "title",
    componentProps: {
      compressed: true,
      fullWidth: true,
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        append: i18n.SCHEDULED_REPORT_FORM_FILE_NAME_SUFFIX,
        readOnly
      }
    }
  }), /*#__PURE__*/_react.default.createElement(FormField, {
    path: "reportTypeId",
    componentProps: {
      compressed: true,
      fullWidth: true,
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        options: (_availableReportTypes = availableReportTypes === null || availableReportTypes === void 0 ? void 0 : availableReportTypes.map(f => ({
          inputDisplay: f.label,
          value: f.id
        }))) !== null && _availableReportTypes !== void 0 ? _availableReportTypes : [],
        readOnly
      }
    }
  }), reportTypeId === 'printablePdfV2' && /*#__PURE__*/_react.default.createElement(FormField, {
    path: "optimizedForPrinting",
    config: {
      type: _hook_form_lib.FIELD_TYPES.TOGGLE,
      label: i18n.SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_LABEL
    },
    componentProps: {
      helpText: i18n.SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_DESCRIPTION,
      euiFieldProps: {
        compressed: true,
        disabled: readOnly
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_responsive_form_group.ResponsiveFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.SCHEDULED_REPORT_FORM_SCHEDULE_SECTION_TITLE)
  }, /*#__PURE__*/_react.default.createElement(FormField, {
    path: "startDate",
    config: {
      type: _hook_form_lib.FIELD_TYPES.DATE_PICKER,
      label: i18n.SCHEDULED_REPORT_FORM_START_DATE_LABEL,
      defaultValue: defaultStartDateValue,
      serializer: _moment2.convertMomentToString,
      deserializer: _moment2.convertStringToMoment,
      validations: [{
        validator: emptyField(i18n.SCHEDULED_REPORT_FORM_START_DATE_REQUIRED_MESSAGE)
      }, {
        validator: (0, _start_date_validator.getStartDateValidator)(now, timezone !== null && timezone !== void 0 ? timezone : defaultTimezone)
      }]
    },
    componentProps: {
      compressed: true,
      fullWidth: true,
      'data-test-subj': 'startDatePicker',
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        showTimeSelect: true,
        minDate: now,
        readOnly
      }
    }
  }), /*#__PURE__*/_react.default.createElement(FormField, {
    path: "timezone",
    config: {
      type: _hook_form_lib.FIELD_TYPES.SUPER_SELECT,
      defaultValue: defaultTimezone,
      validations: [{
        validator: emptyField(i18n.SCHEDULED_REPORT_FORM_START_DATE_REQUIRED_MESSAGE)
      }]
    },
    componentProps: {
      id: 'timezone',
      compressed: true,
      fullWidth: true,
      'data-test-subj': 'timezoneCombobox',
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        options: TIMEZONE_OPTIONS,
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
          htmlFor: "timezone"
        }, i18n.SCHEDULED_REPORT_FORM_TIMEZONE_LABEL),
        readOnly
      }
    }
  }), isRecurring && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_recurring_schedule_form_fields.RecurringScheduleFormFields, {
    startDate: !readOnly ? startDate : undefined,
    timezone: !readOnly ? timezone ? [timezone] : [defaultTimezone] : undefined,
    hideTimezone: true,
    readOnly: readOnly,
    supportsEndOptions: false,
    minFrequency: _rrule.Frequency.MONTHLY,
    showTimeInSummary: true,
    compressed: true
  }))), /*#__PURE__*/_react.default.createElement(_responsive_form_group.ResponsiveFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.SCHEDULED_REPORT_FORM_EXPORTS_SECTION_TITLE),
    description: !readOnly && /*#__PURE__*/_react.default.createElement("p", null, i18n.SCHEDULED_REPORT_FORM_EXPORTS_SECTION_DESCRIPTION, " ", reportingPageLink, ".")
  }, /*#__PURE__*/_react.default.createElement(FormField, {
    path: "sendByEmail",
    componentProps: {
      helpText: !hasManageReportingPrivilege && !(userProfile !== null && userProfile !== void 0 && userProfile.user.email) ? i18n.SCHEDULED_REPORT_FORM_NO_USER_EMAIL_HINT : undefined,
      euiFieldProps: {
        compressed: true,
        disabled: readOnly || !reportingHealth.areNotificationsEnabled || !hasManageReportingPrivilege && !(userProfile !== null && userProfile !== void 0 && userProfile.user.email)
      }
    }
  }), reportingHealth.areNotificationsEnabled ? isEmailActive && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(FormField, {
    path: "emailRecipients",
    componentProps: {
      compressed: true,
      fullWidth: true,
      helpText: !readOnly ? hasManageReportingPrivilege ? i18n.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_HINT : i18n.SCHEDULED_REPORT_FORM_EMAIL_SELF_HINT : undefined,
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        isDisabled: readOnly || !hasManageReportingPrivilege,
        'data-test-subj': 'emailRecipientsCombobox'
      }
    }
  }), !readOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_TITLE,
    iconType: "info",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_MESSAGE)))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_TITLE,
    iconType: "info",
    size: "s",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_MESSAGE)))))), !readOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left"
  }, i18n.SCHEDULED_REPORT_FLYOUT_CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    form: _constants.SCHEDULED_REPORT_FORM_ID,
    "data-test-subj": "scheduleExportSubmitButton",
    isDisabled: isReportingHealthLoading || isUserProfileLoading,
    onClick: onSubmit,
    isLoading: isScheduleExportLoading,
    fill: true
  }, i18n.SCHEDULED_REPORT_FLYOUT_SUBMIT_BUTTON_LABEL)))));
};
exports.ScheduledReportFlyoutContent = ScheduledReportFlyoutContent;