"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.init = init;
exports.setBreadcrumbs = setBreadcrumbs;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let _setBreadcrumbs;
let _breadcrumbs;
function init(setGlobalBreadcrumbs) {
  _setBreadcrumbs = setGlobalBreadcrumbs;
  _breadcrumbs = {
    home: {
      text: _i18n.i18n.translate('xpack.remoteClusters.listBreadcrumbTitle', {
        defaultMessage: 'Remote Clusters'
      }),
      href: `/list`
    },
    add: {
      text: _i18n.i18n.translate('xpack.remoteClusters.addBreadcrumbTitle', {
        defaultMessage: 'Add'
      })
    },
    edit: {
      text: _i18n.i18n.translate('xpack.remoteClusters.editBreadcrumbTitle', {
        defaultMessage: 'Edit'
      })
    }
  };
}
function setBreadcrumbs(type, queryParams) {
  if (!_breadcrumbs[type]) {
    return;
  }
  if (type === 'home') {
    _setBreadcrumbs([_breadcrumbs.home]);
  } else {
    // Support deep-linking back to a remote cluster in the detail panel.
    const homeBreadcrumb = {
      text: _breadcrumbs.home.text,
      href: `${_breadcrumbs.home.href}${queryParams}`
    };
    _setBreadcrumbs([homeBreadcrumb, _breadcrumbs[type]]);
  }
}