"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEsql = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Execute an ES|QL query and returns the response.
 */
const executeEsql = async ({
  query,
  esClient
}) => {
  const response = await esClient.esql.query({
    query,
    drop_null_columns: true
  });
  return {
    columns: response.columns,
    values: response.values
  };
};
exports.executeEsql = executeEsql;