"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchConfiguration = exports.defaultQuery = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultQuery = exports.defaultQuery = {
  language: 'kuery',
  query: ''
};
const searchConfigQueryWarning = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.searchConfiguration.queryWarning', {
  defaultMessage: 'Custom threshold does not support queries other than Query type, query was changed to default query.'
});
const getSearchConfiguration = (fields, onWarning) => {
  if (fields.query && !(0, _esQuery.isOfQueryType)(fields.query)) {
    onWarning(searchConfigQueryWarning);
    return adjustSearchConfigurationFilter({
      ...fields,
      query: defaultQuery
    });
  }
  return adjustSearchConfigurationFilter({
    ...fields,
    query: fields.query
  });
};
exports.getSearchConfiguration = getSearchConfiguration;
const adjustSearchConfigurationFilter = searchConfiguration => {
  // Only meta and query fields are saved in the rule params, so we ignore other fields such as $state
  const filter = searchConfiguration.filter ? searchConfiguration.filter.map(({
    meta,
    query
  }) => ({
    meta,
    query
  })) : undefined;
  return {
    ...searchConfiguration,
    filter
  };
};