"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSeverityBadge = AlertSeverityBadge;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const colorMap = {
  critical: 'danger',
  warning: 'warning'
};
function AlertSeverityBadge({
  severityLevel
}) {
  if (!severityLevel) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: severityLevel ? colorMap[severityLevel] : 'default'
  }, severityLevel);
}