"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeedbackButtons = FeedbackButtons;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _telemetry_events = require("../../../../common/telemetry_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THANK_YOU_MESSAGE = _i18n.i18n.translate('xpack.observability_onboarding.feedbackButtons.em.thanksForYourFeedbackLabel', {
  defaultMessage: 'Thanks for your feedback!'
});
function FeedbackButtons({
  flow
}) {
  const {
    notifications,
    analytics
  } = (0, _public.useKibana)().services;
  const handleClick = feedback => {
    analytics === null || analytics === void 0 ? void 0 : analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_FEEDBACK_TELEMETRY_EVENT.eventType, {
      flow,
      feedback
    });
    notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addSuccess(THANK_YOU_MESSAGE);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("em", null, _i18n.i18n.translate('xpack.observability_onboarding.insight.feedbackButtons.title', {
    defaultMessage: 'Was this helpful?'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "obltOnboardingFeedbackButtonsPositiveButton",
    color: "success",
    iconType: "faceHappy",
    size: "s",
    onClick: () => handleClick('positive')
  }, _i18n.i18n.translate('xpack.observability_onboarding.insight.feedbackButtons.positive', {
    defaultMessage: 'Yes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "obltOnboardingFeedbackButtonsNegativeButton",
    color: "danger",
    iconType: "faceSad",
    size: "s",
    onClick: () => handleClick('negative')
  }, _i18n.i18n.translate('xpack.observability_onboarding.insight.feedbackButtons.negative', {
    defaultMessage: 'No'
  })))))));
}