"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeList = ChangeList;
exports.ChangeListItemImpact = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_theme = require("../../hooks/use_theme");
var _spark_plot = require("../charts/spark_plot");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChangeListItemImpact = exports.ChangeListItemImpact = /*#__PURE__*/function (ChangeListItemImpact) {
  ChangeListItemImpact[ChangeListItemImpact["low"] = 1] = "low";
  ChangeListItemImpact[ChangeListItemImpact["medium"] = 2] = "medium";
  ChangeListItemImpact[ChangeListItemImpact["high"] = 3] = "high";
  return ChangeListItemImpact;
}({});
function getFormattedTimestamp({
  format,
  time
}) {
  return (0, _momentTimezone.default)(time).format(format);
}
function getImpactProperties({
  impact,
  theme
}) {
  if (impact === ChangeListItemImpact.high) {
    return {
      color: theme.colors.danger,
      label: _i18n.i18n.translate('xpack.observabilityAiAssistant.changesList.dotImpactHigh', {
        defaultMessage: 'High'
      })
    };
  }
  if (impact === ChangeListItemImpact.medium) {
    return {
      color: theme.colors.warning,
      label: _i18n.i18n.translate('xpack.observabilityAiAssistant.changesList.dotImpactMedium', {
        defaultMessage: 'Medium'
      })
    };
  }
  return {
    color: theme.colors.darkShade,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistant.changesList.dotImpactLow', {
      defaultMessage: 'Low'
    })
  };
}
function getColumns({
  theme,
  uiSettings
}) {
  const format = uiSettings.get(_managementSettingsIds.DATE_FORMAT_ID);
  const columns = [{
    name: '',
    field: 'change',
    render: (_, {
      change
    }) => {
      if (!change) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "subdued",
          css: (0, _react2.css)`
                white-space: nowrap;
              `
        }, _i18n.i18n.translate('xpack.observabilityAiAssistant.changesList.noChangesDetected', {
          defaultMessage: 'No changes detected'
        }));
      }
      const {
        label,
        color
      } = getImpactProperties({
        theme,
        impact: change.impact
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "xs",
        css: (0, _react2.css)`
              white-space: nowrap;
            `,
        justifyContent: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "none",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: color
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, label)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, change.type)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, getFormattedTimestamp({
        format,
        time: change.time
      }))));
    }
  }, {
    name: _i18n.i18n.translate('xpack.observabilityAiAssistant.changesList.trendColumnTitle', {
      defaultMessage: 'Trend'
    }),
    sortable: false,
    field: 'timeseries',
    render: (_, {
      timeseries,
      change
    }) => {
      return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
        timeseries: timeseries,
        type: "bar",
        annotations: change ? [{
          id: '',
          x: change.time,
          label: getFormattedTimestamp({
            format,
            time: change.time
          }),
          color: getImpactProperties({
            impact: change.impact,
            theme
          }).color,
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "dot"
          })
        }] : []
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.observabilityAiAssistant.changesList.labelColumnTitle', {
      defaultMessage: 'Label'
    }),
    width: '100%',
    field: 'label',
    render: (_, {
      label
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: label
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        css: (0, _react2.css)`
                display: -webkit-box;
                -webkit-line-clamp: 3;
                -webkit-box-orient: vertical;
                overflow: hidden;
                text-overflow: ellipsis;
              `,
        tabIndex: 0
      }, label));
    }
  }];
  return columns;
}
function ChangeList({
  title,
  items
}) {
  const theme = (0, _use_theme.useTheme)();
  const {
    services: {
      uiSettings
    }
  } = (0, _use_kibana.useKibana)();
  const columns = (0, _react.useMemo)(() => {
    return getColumns({
      theme,
      uiSettings
    });
  }, [theme, uiSettings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    tableLayout: "auto"
  })));
}